"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openAnimationTiming = exports.euiPopoverPanelStyles = void 0;
var _react = require("@emotion/react");
var _mixins = require("../../../themes/amsterdam/global_styling/mixins");
var _functions = require("../../../themes/amsterdam/global_styling/functions");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var openAnimationTiming = 'slow';
exports.openAnimationTiming = openAnimationTiming;
var translateDistance = 's';

/**
 * 1. Can expand further, but it looks weird if it's smaller than the originating button.
 * 2. Animation happens on the panel. But don't animate position when using the attached mode like for inputs
 * 3. Make sure the panel stays within the window.
 */

var euiPopoverPanelStyles = function euiPopoverPanelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  return {
    // Base
    euiPopover__panel: /*#__PURE__*/(0, _react.css)("position:absolute;", (0, _global_styling.logicalCSS)('min-width', "".concat(euiTheme.base * 7, "px")), ";", (0, _global_styling.logicalCSS)('max-width', "calc(100vw - ".concat(euiTheme.size.xl, ")")), ";backface-visibility:hidden;pointer-events:none;opacity:0;transform:translateY(0) translateX(0) translateZ(0);", (0, _mixins.euiShadowMedium)(euiThemeContext, {
      property: 'filter'
    }), " &:focus{outline-offset:0;};label:euiPopover__panel;"),
    // Is visible / open
    isOpen: /*#__PURE__*/(0, _react.css)("opacity:1;pointer-events:auto;", _global_styling.euiCanAnimate, "{transition:opacity ", euiTheme.animation.bounce, " ", euiTheme.animation[openAnimationTiming], ",transform ", euiTheme.animation.bounce, " calc(", euiTheme.animation[openAnimationTiming], " + 100ms);};label:isOpen;"),
    // Positions
    top: /*#__PURE__*/(0, _react.css)("transform:translateY(", euiTheme.size[translateDistance], ") translateZ(0);;label:top;"),
    bottom: /*#__PURE__*/(0, _react.css)("transform:translateY(-", euiTheme.size[translateDistance], ") translateZ(0);;label:bottom;"),
    left: /*#__PURE__*/(0, _react.css)("transform:translateX(", euiTheme.size[translateDistance], ") translateZ(0);;label:left;"),
    right: /*#__PURE__*/(0, _react.css)("transform:translateX(-", euiTheme.size[translateDistance], ") translateZ(0);;label:right;"),
    // Attached version overrides
    attached: {
      isOpen: /*#__PURE__*/(0, _react.css)("filter:none;", _global_styling.euiCanAnimate, "{transition:opacity ", euiTheme.animation.bounce, " ", euiTheme.animation[openAnimationTiming], ";};label:isOpen;"),
      top: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadowFlat)(euiThemeContext), ";;label:top;"),
      bottom: /*#__PURE__*/(0, _react.css)((0, _mixins.euiShadow)(euiThemeContext, 'm'), ";;label:bottom;"),
      // Satisfies TS
      left: /*#__PURE__*/(0, _react.css)(";label:left;"),
      right: /*#__PURE__*/(0, _react.css)(";label:right;")
    },
    // Overrides for drag & drop contexts within popovers. This is required because
    // the fixed positions of drag and drop don't work inside of transformed elements
    hasDragDrop: {
      hasDragDrop: /*#__PURE__*/(0, _react.css)("transform:none;filter:none;", (0, _mixins.euiShadowMedium)(euiThemeContext, {
        property: 'box-shadow'
      }), ";;label:hasDragDrop;"),
      // The offset transforms must be recreated in margins
      top: /*#__PURE__*/(0, _react.css)("margin-block-start:", euiTheme.size[translateDistance], ";;label:top;"),
      bottom: /*#__PURE__*/(0, _react.css)("margin-block-start:-", euiTheme.size[translateDistance], ";.euiPopover__arrow{filter:drop-shadow(\n            0 -6px 6px ", (0, _functions.getShadowColor)(euiTheme.colors.shadow, 0.12, colorMode), "\n          );};label:bottom;"),
      left: /*#__PURE__*/(0, _react.css)("margin-inline-start:", euiTheme.size[translateDistance], ";.euiPopover__arrow{filter:drop-shadow(\n            6px 0 6px ", (0, _functions.getShadowColor)(euiTheme.colors.shadow, 0.12, colorMode), "\n          );};label:left;"),
      right: /*#__PURE__*/(0, _react.css)("margin-inline-start:-", euiTheme.size[translateDistance], ";.euiPopover__arrow{filter:drop-shadow(\n            -6px 0 6px ", (0, _functions.getShadowColor)(euiTheme.colors.shadow, 0.12, colorMode), "\n          );};label:right;")
    }
  };
};
exports.euiPopoverPanelStyles = euiPopoverPanelStyles;