"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiPanel = exports.COLORS = exports.BORDER_RADII = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _common = require("../common");
var _panel = require("./panel.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "paddingSize", "borderRadius", "color", "hasShadow", "hasBorder", "grow", "panelRef", "element"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var SIZES = _global_styling.PADDING_SIZES;

// Exported padding sizes and class names necessary for EuiPopover and EuiCard.
// Which currently will only maintain support for the original values until conversion.
exports.SIZES = SIZES;
var paddingSizeToClassNameMap = {
  none: null,
  s: 'paddingSmall',
  m: 'paddingMedium',
  l: 'paddingLarge'
};
var _SIZES = (0, _common.keysOf)(paddingSizeToClassNameMap);
var BORDER_RADII = ['none', 'm'];
exports.BORDER_RADII = BORDER_RADII;
var COLORS = _global_styling.BACKGROUND_COLORS;
exports.COLORS = COLORS;
var EuiPanel = function EuiPanel(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'm' : _ref$paddingSize,
    _ref$borderRadius = _ref.borderRadius,
    borderRadius = _ref$borderRadius === void 0 ? 'm' : _ref$borderRadius,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'plain' : _ref$color,
    _ref$hasShadow = _ref.hasShadow,
    hasShadow = _ref$hasShadow === void 0 ? true : _ref$hasShadow,
    _ref$hasBorder = _ref.hasBorder,
    hasBorder = _ref$hasBorder === void 0 ? false : _ref$hasBorder,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    panelRef = _ref.panelRef,
    element = _ref.element,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  // Shadows are only allowed when there's a white background (plain)
  var canHaveShadow = !hasBorder && color === 'plain';
  var canHaveBorder = color === 'plain' || color === 'transparent';
  var styles = (0, _panel.euiPanelStyles)(euiTheme);
  var cssStyles = [styles.euiPanel, grow && styles.grow, styles.radius[borderRadius], (0, _global_styling.useEuiPaddingCSS)()[paddingSize], (0, _global_styling.useEuiBackgroundColorCSS)()[color], canHaveShadow && hasShadow === true && styles.hasShadow, canHaveBorder && hasBorder === true && styles.hasBorder, rest.onClick && styles.isClickable];
  var classes = (0, _classnames.default)('euiPanel', "euiPanel--".concat(color), _defineProperty({}, "euiPanel--".concat(paddingSizeToClassNameMap[paddingSize]), paddingSizeToClassNameMap[paddingSize]), className);
  if (rest.onClick && element !== 'div') {
    return (0, _react2.jsx)("button", _extends({
      ref: panelRef,
      className: classes,
      css: cssStyles
    }, rest), children);
  }
  return (0, _react2.jsx)("div", _extends({
    ref: panelRef,
    className: classes,
    css: cssStyles
  }, rest), children);
};
exports.EuiPanel = EuiPanel;
EuiPanel.propTypes = {
  element: _propTypes.default.oneOfType([_propTypes.default.oneOf(["button"]), _propTypes.default.oneOf(["div"])]),
  /**
     * Adds a medium shadow to the panel;
     * Only works when `color="plain"`
     */
  /**
     * Adds a medium shadow to the panel;
     * Only works when `color="plain"`
     */
  hasShadow: _propTypes.default.bool,
  /**
     * Adds a slight 1px border on all edges.
     * Only works when `color="plain | transparent"`
     */
  /**
     * Adds a slight 1px border on all edges.
     * Only works when `color="plain | transparent"`
     */
  hasBorder: _propTypes.default.bool,
  /**
     * Padding for all four sides
     */
  /**
     * Padding for all four sides
     */
  paddingSize: _propTypes.default.any,
  /**
     * Corner border radius
     */
  /**
     * Corner border radius
     */
  borderRadius: _propTypes.default.any,
  /**
     * When true the panel will grow in height to match `EuiFlexItem`
     */
  /**
     * When true the panel will grow in height to match `EuiFlexItem`
     */
  grow: _propTypes.default.bool,
  panelRef: _propTypes.default.any,
  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  color: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};