"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiMarkStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _accessibility = require("../accessibility");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiMarkStyles = function euiMarkStyles(_ref, _ref2) {
  var euiTheme = _ref.euiTheme,
    colorMode = _ref.colorMode;
  var hasScreenReaderHelpText = _ref2.hasScreenReaderHelpText,
    highlightStart = _ref2.highlightStart,
    highlightEnd = _ref2.highlightEnd;
  // TODO: Was $euiFocusBackgroundColor
  var transparency = {
    LIGHT: 0.1,
    DARK: 0.3
  };
  return /*#__PURE__*/(0, _react.css)("background-color:", (0, _services.transparentize)(euiTheme.colors.primary, transparency[colorMode]), ";font-weight:", euiTheme.font.weight.bold, ";color:", euiTheme.colors.text, ";", hasScreenReaderHelpText === true && "\n      &:before,\n      &:after {\n        ".concat((0, _accessibility.euiScreenReaderOnly)(), "\n      }\n\n      &:before {\n        content: ' [").concat(highlightStart, "] ';\n      }\n\n      &:after {\n        content: ' [").concat(highlightEnd, "] ';\n      }\n    "), ";;label:euiMarkStyles;");
};
exports.euiMarkStyles = euiMarkStyles;