"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiHorizontalRuleStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiHorizontalRuleStyles = function euiHorizontalRuleStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiHorizontalRule: /*#__PURE__*/(0, _react.css)("border:none;", (0, _global_styling.logicalCSS)('height', euiTheme.border.width.thin), " background-color:", euiTheme.border.color, ";flex-shrink:0;flex-grow:0;;label:euiHorizontalRule;"),
    // Sizes
    full: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '100%'), ";;label:full;"),
    half: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '50%'), " ", (0, _global_styling.logicalCSS)('margin-horizontal', 'auto'), ";;label:half;"),
    quarter: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', '25%'), " ", (0, _global_styling.logicalCSS)('margin-horizontal', 'auto'), ";;label:quarter;"),
    // Margins
    none: '',
    xs: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.s, ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.m, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.l, ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.xl, ";;label:xl;"),
    xxl: /*#__PURE__*/(0, _react.css)("margin-block:", euiTheme.size.xxl, ";;label:xxl;")
  };
};
exports.euiHorizontalRuleStyles = euiHorizontalRuleStyles;