"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeTrack = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _range = _interopRequireDefault(require("lodash/range"));
var _services = require("../../../services");
var _range_levels = require("./range_levels");
var _range_ticks = require("./range_ticks");
var _range_track = require("./range_track.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "disabled", "max", "min", "step", "showTicks", "tickInterval", "ticks", "levels", "onChange", "value", "compressed", "showRange", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiRangeTrack = function EuiRangeTrack(_ref) {
  var children = _ref.children,
    disabled = _ref.disabled,
    max = _ref.max,
    min = _ref.min,
    step = _ref.step,
    showTicks = _ref.showTicks,
    tickInterval = _ref.tickInterval,
    ticks = _ref.ticks,
    levels = _ref.levels,
    onChange = _ref.onChange,
    value = _ref.value,
    compressed = _ref.compressed,
    showRange = _ref.showRange,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  (0, _react.useEffect)(function () {
    validateValueIsInStep(max, {
      min: min,
      max: max,
      step: step
    });
  }, [value, min, max, step]);
  var _useState = (0, _react.useState)(0),
    _useState2 = _slicedToArray(_useState, 2),
    trackWidth = _useState2[0],
    setTrackWidth = _useState2[1];
  var tickSequence = (0, _react.useMemo)(function () {
    if (showTicks !== true) return;
    var sequence;
    if (ticks) {
      // If custom values were passed, use those for the sequence
      // But make sure they align with the possible sequence
      sequence = ticks.map(function (tick) {
        return validateValueIsInStep(tick.value, {
          min: min,
          max: max,
          step: step
        });
      });
    } else {
      // If a custom interval was passed, use those for the sequence
      // But make sure they align with the possible sequence
      var interval = tickInterval || step;

      // Calculate sequence - loop from min to max, creating adding values at each interval
      var sequenceRange = (0, _range.default)(min, max, interval);
      // range is non-inclusive of max, so make it inclusive
      if (max % interval === 0 && !sequenceRange.includes(max)) {
        sequenceRange.push(max);
      }
      sequence = sequenceRange.map(function (tick) {
        return validateValueIsInStep(tick, {
          min: min,
          max: max,
          step: step
        });
      });
    }

    // Error out if there are too many ticks to render
    if (trackWidth && sequence.length) {
      validateTickRenderCount(trackWidth, sequence.length);
    }
    return sequence;
  }, [showTicks, ticks, min, max, tickInterval, step, trackWidth]);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_track.euiRangeTrackStyles)(euiTheme);
  var cssStyles = [styles.euiRangeTrack, disabled && styles.disabled, levels && !!levels.length && styles.hasLevels, showTicks && (tickSequence || ticks) && styles.hasTicks];
  var classes = (0, _classnames.default)('euiRangeTrack', className);
  return (0, _react2.jsx)("div", _extends({
    className: classes,
    css: cssStyles
  }, rest, {
    ref: function ref(node) {
      var _node$clientWidth;
      setTrackWidth((_node$clientWidth = node === null || node === void 0 ? void 0 : node.clientWidth) !== null && _node$clientWidth !== void 0 ? _node$clientWidth : 0);
    }
  }), levels && !!levels.length && (0, _react2.jsx)(_range_levels.EuiRangeLevels, {
    levels: levels,
    max: max,
    min: min,
    showTicks: showTicks,
    showRange: showRange,
    trackWidth: trackWidth
  }), tickSequence && (0, _react2.jsx)(_range_ticks.EuiRangeTicks, {
    disabled: disabled,
    compressed: compressed,
    onChange: onChange,
    ticks: ticks,
    tickInterval: tickInterval || step,
    tickSequence: tickSequence,
    value: value,
    min: min,
    max: max,
    trackWidth: trackWidth
  }), typeof children === 'function' ? children(trackWidth) : children);
};
exports.EuiRangeTrack = EuiRangeTrack;
EuiRangeTrack.propTypes = {
  onChange: _propTypes.default.func,
  children: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.func.isRequired]),
  value: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired, _propTypes.default.any.isRequired]),
  max: _propTypes.default.number.isRequired,
  min: _propTypes.default.number.isRequired,
  /**
     * The number to increment or decrement between each interval
     * @default 1
     */
  step: _propTypes.default.number,
  /**
     * Specified ticks at specified values
     */
  ticks: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.number.isRequired,
    label: _propTypes.default.node.isRequired
  }).isRequired),
  /**
     * Modifies the number of tick marks and at what interval
     */
  tickInterval: _propTypes.default.number,
  /**
     * Create colored indicators for certain intervals.
     * An array of #EuiRangeLevel objects
     */
  levels: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Accepts one of `["primary", "success", "warning", "danger"]` or a valid CSS color value.
       */
    color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired)
};
var validateValueIsInStep = function validateValueIsInStep(value, _ref2) {
  var min = _ref2.min,
    max = _ref2.max,
    step = _ref2.step;
  if (value < min) {
    throw new Error("The value of ".concat(value, " is lower than the min value of ").concat(min, "."));
  }
  if (value > max) {
    throw new Error("The value of ".concat(value, " is higher than the max value of ").concat(max, "."));
  }
  // Error out if the value doesn't line up with the sequence of steps
  if (!(0, _services.isEvenlyDivisibleBy)(value - min, step !== undefined ? step : 1)) {
    throw new Error("The value of ".concat(value, " is not included in the possible sequence provided by the step of ").concat(step, "."));
  }
  // Return the value if nothing fails
  return value;
};
var validateTickRenderCount = function validateTickRenderCount(trackWidth, tickCount) {
  var tickWidth = trackWidth / tickCount;

  // These widths are guesstimations - it's possible we should use actual label content/widths instead
  var COMFORTABLE_TICK_WIDTH = 20; // Set a warning threshold before throwing
  var MIN_TICK_WIDTH = 5; // If ticks are smaller than this, something's gone seriously wrong and we should throw

  var message = "The number of ticks to render (".concat(tickCount, ") is too high for the range width. Ensure all ticks are visible on the page at multiple screen widths, or use EUI's breakpoint hook utilities to reduce the tick interval responsively.");
  if (tickWidth <= MIN_TICK_WIDTH) {
    throw new Error(message);
  } else if (tickWidth < COMFORTABLE_TICK_WIDTH) {
    console.warn(message);
  }
};