"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiRangeTicksStyles = exports.euiRangeTickStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _range = require("./range.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var tickStyles = function tickStyles(_ref4, range) {
  var euiTheme = _ref4.euiTheme;
  return "\n    position: absolute;\n    ".concat((0, _global_styling.logicalCSS)('top', 0), ";\n    ").concat((0, _global_styling.logicalSizeCSS)(euiTheme.size.xs, euiTheme.size.xs), ";\n    background-color: ").concat(euiTheme.colors.lightShade, ";\n    inline-size: ").concat(range.tickWidth, ";\n    block-size: ").concat(range.tickHeight, ";\n    border-radius: ").concat(euiTheme.border.radius.small, ";\n  ");
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1sbhdc4-euiRangeTicks",
  styles: "position:absolute;inset-inline:0;display:flex;label:euiRangeTicks;"
} : {
  name: "1sbhdc4-euiRangeTicks",
  styles: "position:absolute;inset-inline:0;display:flex;label:euiRangeTicks;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiRangeTicksStyles = function euiRangeTicksStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    // Base
    euiRangeTicks: _ref3,
    isCustom: /*#__PURE__*/(0, _react.css)("inset-inline:", (0, _global_styling.mathWithUnits)(range.thumbWidth, function (x) {
      return x / 8;
    }), ";;label:isCustom;"),
    // compressed and non-compressed styles
    regular: /*#__PURE__*/(0, _react.css)("block-size:", (0, _global_styling.mathWithUnits)([range.height, range.thumbHeight], function (x, y) {
      return x - y;
    }), ";inset-block-start:", range.thumbHeight, ";;label:regular;"),
    compressed: /*#__PURE__*/(0, _react.css)("block-size:", (0, _global_styling.mathWithUnits)([range.compressedHeight, range.trackBottomPositionWithTicks], function (x, y) {
      return x - y;
    }), ";inset-block-start:", (0, _global_styling.mathWithUnits)([range.thumbHeight, range.trackHeight], function (x, y) {
      return x - (x - y) / 2;
    }), ";;label:compressed;")
  };
};
exports.euiRangeTicksStyles = euiRangeTicksStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "jgvly2-isMax",
  styles: "transform:translateX(0);.euiRangeTick__pseudo{inset-inline-end:0;};label:isMax;"
} : {
  name: "jgvly2-isMax",
  styles: "transform:translateX(0);.euiRangeTick__pseudo{inset-inline-end:0;};label:isMax;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1nx14mu-isMin",
  styles: "transform:translateX(0);.euiRangeTick__pseudo{inset-inline-start:0;};label:isMin;"
} : {
  name: "1nx14mu-isMin",
  styles: "transform:translateX(0);.euiRangeTick__pseudo{inset-inline-start:0;};label:isMin;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiRangeTickStyles = function euiRangeTickStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    // Base
    euiRangeTick: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSSWithFallback)('overflow-x', 'hidden'), " ", (0, _global_styling.logicalCSSWithFallback)('overflow-y', 'hidden'), " text-overflow:ellipsis;font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";position:absolute;transform:translateX(-50%);&:disabled{cursor:not-allowed;}&:enabled:hover,&:focus{color:", range.focusColor, ";};label:euiRangeTick;"),
    // compressed and non-compressed styles
    compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-top', euiTheme.size.s), ";&::before{", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.xxs), ";};label:compressed;"),
    regular: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('padding-top', euiTheme.size.m), ";;label:regular;"),
    selected: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.medium, ";color:", range.focusColor, ";;label:selected;"),
    isCustom: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSSWithFallback)('overflow-x', 'hidden'), ";;label:isCustom;"),
    // Tick marks can use either a ::before pseudo element or a span __pseudo node
    hasPseudoTickMark: /*#__PURE__*/(0, _react.css)("&::before{", tickStyles(euiThemeContext, range), " content:'';inset-inline-start:calc(50% - ", range.thumbBorderWidth, ");};label:hasPseudoTickMark;"),
    euiRangeTick__pseudo: /*#__PURE__*/(0, _react.css)(tickStyles(euiThemeContext, range), ";;label:euiRangeTick__pseudo;"),
    isMin: _ref2,
    isMax: _ref
  };
};
exports.euiRangeTickStyles = euiRangeTickStyles;