"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeHighlight = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _range_highlight = require("./range_highlight.styles");
var _range_levels = require("./range_levels");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiRangeHighlight = function EuiRangeHighlight(_ref) {
  var className = _ref.className,
    showTicks = _ref.showTicks,
    trackWidth = _ref.trackWidth,
    lowerValue = _ref.lowerValue,
    upperValue = _ref.upperValue,
    max = _ref.max,
    min = _ref.min,
    background = _ref.background,
    onClick = _ref.onClick,
    levels = _ref.levels;
  // Calculate the width of the range based on value
  var leftPosition = (0, _react.useMemo)(function () {
    return (lowerValue - min) / (max - min);
  }, [lowerValue, min, max]);
  var rangeWidth = (0, _react.useMemo)(function () {
    return (upperValue - lowerValue) / (max - min);
  }, [upperValue, lowerValue, min, max]);
  var classes = (0, _classnames.default)('euiRangeHighlight', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_highlight.euiRangeHighlightStyles)(euiTheme);
  var cssStyles = [styles.euiRangeHighlight, showTicks && styles.hasTicks];
  var progressStyles = (0, _range_highlight.euiRangeHighlightProgressStyles)(euiTheme);
  var cssProgressStyles = [progressStyles.euiRangeHighlight__progress];
  var progressStyle = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)({
      background: background,
      marginLeft: "".concat(leftPosition * 100, "%"),
      width: "".concat(rangeWidth * 100, "%")
    });
  }, [background, leftPosition, rangeWidth]);
  var levelsWrapperStyles = (0, _range_highlight.euiRangeHighlightLevelsWrapperStyles)(euiTheme);
  var cssLevelsWrapperStyles = [levelsWrapperStyles.euiRangeHighlight__levelsWrapper];
  var levelsWrapperStyle = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)({
      marginLeft: "".concat(leftPosition * 100, "%"),
      width: "".concat(rangeWidth * 100, "%")
    });
  }, [leftPosition, rangeWidth]);
  var levelsStyles = (0, _range_highlight.euiRangeHighlightLevelsStyles)(euiTheme);
  var cssLevelsStyles = [levelsStyles.euiRangeHighlight__levels];
  var levelsStyle = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)({
      left: "-".concat(trackWidth * leftPosition, "px"),
      width: "".concat(trackWidth, "px")
    });
  }, [trackWidth, leftPosition]);
  return (0, _react2.jsx)("div", {
    className: classes,
    css: cssStyles,
    onClick: onClick
  }, (levels && levels.length === 0 || !levels) && (0, _react2.jsx)("div", {
    className: "euiRangeHighlight__progress",
    css: cssProgressStyles,
    style: progressStyle
  }), levels && !!levels.length && (0, _react2.jsx)("div", {
    css: cssLevelsWrapperStyles,
    style: levelsWrapperStyle
  }, (0, _react2.jsx)(_range_levels.EuiRangeLevels, {
    css: cssLevelsStyles,
    style: levelsStyle,
    levels: levels,
    max: max,
    min: min,
    showTicks: showTicks,
    trackWidth: trackWidth
  })));
};
exports.EuiRangeHighlight = EuiRangeHighlight;
EuiRangeHighlight.propTypes = {
  className: _propTypes.default.string,
  background: _propTypes.default.string,
  trackWidth: _propTypes.default.number.isRequired,
  lowerValue: _propTypes.default.number.isRequired,
  upperValue: _propTypes.default.number.isRequired,
  onClick: _propTypes.default.func
};