"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFocusTrap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactFocusOn = require("react-focus-on");
var _reactRemoveScrollBar = require("react-remove-scroll-bar");
var _services = require("../../services");
var _react2 = require("@emotion/react");
var _excluded = ["children", "clickOutsideDisables", "disabled", "returnFocus", "noIsolation", "scrollLock", "gapMode"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
                                                                                                                                                                                                                                                                                                                                                                                               * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                               * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                               * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                               * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                               * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                               */
var EuiFocusTrap = /*#__PURE__*/function (_Component) {
  _inherits(EuiFocusTrap, _Component);
  var _super = _createSuper(EuiFocusTrap);
  function EuiFocusTrap() {
    var _this;
    _classCallCheck(this, EuiFocusTrap);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "state", {
      hasBeenDisabledByClick: false
    });
    _defineProperty(_assertThisInitialized(_this), "lastInterceptedEvent", null);
    _defineProperty(_assertThisInitialized(_this), "preventFocusExit", false);
    // Programmatically sets focus on a nested DOM node; optional
    _defineProperty(_assertThisInitialized(_this), "setInitialFocus", function (initialFocus) {
      if (!initialFocus) return;
      var node = (0, _services.findElementBySelectorOrRef)(initialFocus);
      if (!node) return;
      // `data-autofocus` is part of the 'react-focus-on' API
      node.setAttribute('data-autofocus', 'true');
    });
    _defineProperty(_assertThisInitialized(_this), "onMouseupOutside", function (e) {
      _this.removeMouseupListener();
      // Timeout gives precedence to the consumer to initiate close if it has toggle behavior.
      // Otherwise this event may occur first and the consumer toggle will reopen the flyout.
      setTimeout(function () {
        var _this$props$onClickOu, _this$props;
        return (_this$props$onClickOu = (_this$props = _this.props).onClickOutside) === null || _this$props$onClickOu === void 0 ? void 0 : _this$props$onClickOu.call(_this$props, e);
      });
    });
    _defineProperty(_assertThisInitialized(_this), "addMouseupListener", function () {
      document.addEventListener('mouseup', _this.onMouseupOutside);
      document.addEventListener('touchend', _this.onMouseupOutside);
    });
    _defineProperty(_assertThisInitialized(_this), "removeMouseupListener", function () {
      document.removeEventListener('mouseup', _this.onMouseupOutside);
      document.removeEventListener('touchend', _this.onMouseupOutside);
    });
    _defineProperty(_assertThisInitialized(_this), "handleOutsideClick", function (event) {
      var _this$props2 = _this.props,
        onClickOutside = _this$props2.onClickOutside,
        clickOutsideDisables = _this$props2.clickOutsideDisables,
        closeOnMouseup = _this$props2.closeOnMouseup;
      if (clickOutsideDisables) {
        _this.setState({
          hasBeenDisabledByClick: true
        });
      }
      if (onClickOutside) {
        closeOnMouseup ? _this.addMouseupListener() : onClickOutside(event);
      }
    });
    return _this;
  }
  _createClass(EuiFocusTrap, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setInitialFocus(this.props.initialFocus);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.disabled === true && this.props.disabled === false) {
        this.setState({
          hasBeenDisabledByClick: false
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.removeMouseupListener();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
        children = _this$props3.children,
        clickOutsideDisables = _this$props3.clickOutsideDisables,
        disabled = _this$props3.disabled,
        returnFocus = _this$props3.returnFocus,
        noIsolation = _this$props3.noIsolation,
        scrollLock = _this$props3.scrollLock,
        gapMode = _this$props3.gapMode,
        rest = _objectWithoutProperties(_this$props3, _excluded);
      var isDisabled = disabled || this.state.hasBeenDisabledByClick;
      var focusOnProps = _objectSpread(_objectSpread({
        returnFocus: returnFocus,
        noIsolation: noIsolation,
        enabled: !isDisabled
      }, rest), {}, {
        onClickOutside: this.handleOutsideClick,
        /**
         * `scrollLock` should always be unset on FocusOn, as it can prevent scrolling on
         * portals (i.e. popovers, comboboxes, dropdown menus, etc.) within modals & flyouts
         * @see https://github.com/theKashey/react-focus-on/issues/49
         */
        scrollLock: false
      });
      return (0, _react2.jsx)(_reactFocusOn.FocusOn, focusOnProps, children, !isDisabled && scrollLock && (0, _react2.jsx)(_reactRemoveScrollBar.RemoveScrollBar, {
        gapMode: gapMode
      }));
    }
  }]);
  return EuiFocusTrap;
}(_react.Component);
exports.EuiFocusTrap = EuiFocusTrap;
_defineProperty(EuiFocusTrap, "defaultProps", {
  clickOutsideDisables: false,
  disabled: false,
  returnFocus: true,
  noIsolation: true,
  scrollLock: false,
  gapMode: 'padding' // EUI defaults to padding because Kibana's body/layout CSS ignores `margin`
});
EuiFocusTrap.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Whether `onClickOutside` should be called on mouseup instead of mousedown.
     * This flag can be used to prevent conflicts with outside toggle buttons by delaying the closing click callback.
     */
  closeOnMouseup: _propTypes.default.bool,
  /**
     * Clicking outside the trap area will disable the trap
     */
  clickOutsideDisables: _propTypes.default.bool,
  /**
     * Reference to element that will get focus when the trap is initiated
     */
  initialFocus: _propTypes.default.any,
  style: _propTypes.default.any,
  /**
     * if `scrollLock` is set to true, the body's scrollbar width will be preserved on lock
     * via the `gapMode` CSS property. Depending on your custom CSS, you may prefer to use
     * `margin` instead of `padding`.
     */
  gapMode: _propTypes.default.oneOf(["padding", "margin"]),
  disabled: _propTypes.default.bool
};