"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDescriptionListTitleStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
var _title = require("../title/title.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDescriptionListTitleStyles = function euiDescriptionListTitleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var columnDisplay = "\n  ".concat((0, _global_styling.logicalCSS)('width', '50%'), "\n    ").concat((0, _global_styling.logicalCSS)('padding-right', euiTheme.size.s), "\n  ");
  return {
    euiDescriptionList__title: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextBreakWord)(), ";;label:euiDescriptionList__title;"),
    // Types
    row: /*#__PURE__*/(0, _react.css)(";label:row;"),
    column: /*#__PURE__*/(0, _react.css)(columnDisplay, ";;label:column;"),
    responsiveColumn: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiMaxBreakpoint)(euiThemeContext, 'm'), "{", (0, _global_styling.logicalCSS)('width', '100%'), " padding:0;}", (0, _global_styling.euiMinBreakpoint)(euiThemeContext, 'm'), "{", columnDisplay, ";};label:responsiveColumn;"),
    inline: /*#__PURE__*/(0, _react.css)("display:inline;border-radius:", euiTheme.border.radius.small, ";font-weight:", euiTheme.font.weight.medium, ";background-color:", colorMode === 'DARK' ? (0, _services.tint)(euiTheme.colors.lightestShade, 0.5) : euiTheme.colors.lightestShade, ";", (0, _global_styling.logicalCSS)('margin-vertical', '0'), " ", (0, _global_styling.logicalCSS)('margin-horizontal', euiTheme.size.xs), "&:first-of-type{", (0, _global_styling.logicalCSS)('margin-left', '0'), ";};label:inline;"),
    // This nested block handles just the font styling based on compressed and reverse
    fontStyles: {
      normal: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xs'), ";;label:normal;"),
      reverse: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";;label:reverse;"),
      compressed: /*#__PURE__*/(0, _react.css)((0, _title.euiTitle)(euiThemeContext, 'xxs'), ";;label:compressed;")
    },
    // Inline types
    inlineStyles: {
      normal: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";", (0, _global_styling.logicalCSS)('padding-vertical', '1px'), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), ";;label:normal;"),
      compressed: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), ";", (0, _global_styling.logicalCSS)('padding-vertical', '0'), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.xs), ";;label:compressed;")
    },
    // Alignment
    right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalTextAlignCSS)('right'), ";;label:right;"),
    // Gutter
    // Add margin only to the non-first <dt>.
    s: /*#__PURE__*/(0, _react.css)("&:not(:first-of-type){", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.s), ";};label:s;"),
    m: /*#__PURE__*/(0, _react.css)("&:not(:first-of-type){", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.base), ";};label:m;")
  };
};
exports.euiDescriptionListTitleStyles = euiDescriptionListTitleStyles;