"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDatePickerRangeStyles = exports.euiDatePickerRangeInlineStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
var _form = require("../form/form.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDatePickerRangeStyles = function euiDatePickerRangeStyles(euiThemeContext) {
  var _euiFormVariables = (0, _form.euiFormVariables)(euiThemeContext),
    controlLayoutGroupInputHeight = _euiFormVariables.controlLayoutGroupInputHeight;
  return {
    euiDatePickerRange: /*#__PURE__*/(0, _react.css)(".euiFieldText.euiDatePicker{", (0, _global_styling.logicalCSS)('height', controlLayoutGroupInputHeight), ";};label:euiDatePickerRange;")
  };
};
exports.euiDatePickerRangeStyles = euiDatePickerRangeStyles;
var euiDatePickerRangeInlineStyles = function euiDatePickerRangeInlineStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;

  // Use a container query to stack date pickers vertically if the container is
  // not wide enough to fit both. We need a fn for this to render two width queries,
  // depending on whether time selection is being rendered or not
  var containerQuery = function containerQuery(datePickerWidth) {
    var delimiterWidth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 16;
    return "\n    display: block;\n    container-type: inline-size;\n\n    .euiFormControlLayout__childrenWrapper {\n      // Use static px widths for now, since render behavior comes from a third party library\n      @container (max-width: ".concat(datePickerWidth * 2 + delimiterWidth, "px) {\n        // Unset grid display\n        display: block !important;\n\n        // Center and point the default delimiter arrow downwards\n        & > .euiText > [data-icon-type='sortRight'] {\n          transform: rotate(90deg);\n          margin-inline: auto;\n        }\n      }\n    }");
  };
  return {
    inline: /*#__PURE__*/(0, _react.css)(".euiFormControlLayoutDelimited{", (0, _global_styling.logicalCSS)('height', 'auto'), " ", (0, _global_styling.logicalCSS)('width', 'fit-content'), " ", (0, _global_styling.logicalCSS)('max-width', '100%'), " background-color:transparent;box-shadow:none;padding:0;.euiFormControlLayout__childrenWrapper{display:grid;grid-template-columns:1fr auto 1fr;grid-template-rows:auto;align-items:stretch;background-color:transparent;}&.euiFormControlLayout--group{&>*,.euiFormControlLayoutDelimited__delimiter{", (0, _global_styling.logicalCSS)('height', 'auto'), ";}}.euiFormControlLayoutIcons{justify-content:center;grid-column:1/span 3;", (0, _global_styling.logicalCSS)('height', 'auto'), " ", (0, _global_styling.logicalCSS)('padding-bottom', euiTheme.size.s), ";}}.react-datepicker{position:relative;}.react-datepicker__time-list{padding:0;};label:inline;"),
    responsive: /*#__PURE__*/(0, _react.css)(containerQuery(268), ";;label:responsive;"),
    responsiveWithTimeSelect: /*#__PURE__*/(0, _react.css)(containerQuery(350), ";;label:responsiveWithTimeSelect;"),
    shadow: /*#__PURE__*/(0, _react.css)(".euiFormControlLayoutDelimited{", (0, _mixins.euiShadowMedium)(euiThemeContext), " .euiFormControlLayout__childrenWrapper{background-color:", euiTheme.colors.emptyShade, ";}};label:shadow;")
  };
};
exports.euiDatePickerRangeInlineStyles = euiDatePickerRangeInlineStyles;