"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emptyControlColumns = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// since react-window doesn't export a type with the imperative api only we can
// use this to omit the react-specific class component methods

// An array of [x,y] coordinates. Note that the `y` value expected internally is a `visibleRowIndex`

// Force either aria-label or aria-labelledby to be defined

/**
 * Props shared between renderCellValue and renderCellPopover
 */

// The empty control column array fallbacks need to be cached, or
// they'll cause rerendering/remount issues in memoized dependencies
var emptyControlColumns = [];

// Types for styling options, passed down through the `gridStyle` prop

// ideally this would use a generic to enforce `pageSize` exists in `pageSizeOptions`,
// but TypeScript's default understanding of an array is number[] unless `as const` is used
// which defeats the generic's purpose & functionality as it would check for `number` in `number[]`
exports.emptyControlColumns = emptyControlColumns;