"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCellPopover = exports.JsonPopoverContent = exports.DefaultCellPopover = exports.DataGridCellPopoverContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _popover = require("../../popover");
var _text = require("../../text");
var _code = require("../../code");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; } /*
                                                                       * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                       * or more contributor license agreements. Licensed under the Elastic License
                                                                       * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                       * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                       * Side Public License, v 1.
                                                                       */
var DataGridCellPopoverContext = /*#__PURE__*/(0, _react.createContext)({
  popoverIsOpen: false,
  cellLocation: {
    rowIndex: 0,
    colIndex: 0
  },
  openCellPopover: function openCellPopover() {},
  closeCellPopover: function closeCellPopover() {},
  setPopoverAnchor: function setPopoverAnchor() {},
  setPopoverContent: function setPopoverContent() {},
  setCellPopoverProps: function setCellPopoverProps() {}
});
exports.DataGridCellPopoverContext = DataGridCellPopoverContext;
var useCellPopover = function useCellPopover() {
  var _cellPopoverProps$pan;
  // Current open state & cell location are handled here
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    popoverIsOpen = _useState2[0],
    setPopoverIsOpen = _useState2[1];
  var _useState3 = (0, _react.useState)({
      rowIndex: 0,
      colIndex: 0
    }),
    _useState4 = _slicedToArray(_useState3, 2),
    cellLocation = _useState4[0],
    setCellLocation = _useState4[1];
  // Popover anchor & content are passed by individual `EuiDataGridCell`s
  var _useState5 = (0, _react.useState)(null),
    _useState6 = _slicedToArray(_useState5, 2),
    popoverAnchor = _useState6[0],
    setPopoverAnchor = _useState6[1];
  var _useState7 = (0, _react.useState)(),
    _useState8 = _slicedToArray(_useState7, 2),
    popoverContent = _useState8[0],
    setPopoverContent = _useState8[1];
  // Allow customization of most (not all) popover props by consumers
  var _useState9 = (0, _react.useState)({}),
    _useState10 = _slicedToArray(_useState9, 2),
    cellPopoverProps = _useState10[0],
    setCellPopoverProps = _useState10[1];
  var closeCellPopover = (0, _react.useCallback)(function () {
    return setPopoverIsOpen(false);
  }, []);
  var openCellPopover = (0, _react.useCallback)(function (_ref) {
    var rowIndex = _ref.rowIndex,
      colIndex = _ref.colIndex;
    // Prevent popover DOM issues when re-opening the same popover
    if (popoverIsOpen && rowIndex === cellLocation.rowIndex && colIndex === cellLocation.colIndex) {
      return;
    }

    // Toggle our open cell state, which causes EuiDataGridCells to react/check
    // if they should be the open popover and send their anchor+content if so
    setPopoverAnchor(null); // Resetting the anchor node is required for rerendering to work correctly
    setCellLocation({
      rowIndex: rowIndex,
      colIndex: colIndex
    });
    setPopoverIsOpen(true);
  }, [popoverIsOpen, cellLocation]);
  var cellPopoverContext = {
    popoverIsOpen: popoverIsOpen,
    closeCellPopover: closeCellPopover,
    openCellPopover: openCellPopover,
    cellLocation: cellLocation,
    setPopoverAnchor: setPopoverAnchor,
    setPopoverContent: setPopoverContent,
    setCellPopoverProps: setCellPopoverProps
  };

  // Note that this popover is rendered once at the top grid level, rather than one popover per cell
  var cellPopover = popoverIsOpen && popoverAnchor && (0, _react2.jsx)(_popover.EuiWrappingPopover, _extends({
    isOpen: popoverIsOpen,
    display: "block",
    hasArrow: false,
    panelPaddingSize: "s"
  }, cellPopoverProps, {
    panelProps: _objectSpread({
      'data-test-subj': 'euiDataGridExpansionPopover'
    }, cellPopoverProps.panelProps || {}),
    panelClassName: (0, _classnames.default)('euiDataGridRowCell__popover', cellPopoverProps.panelClassName, (_cellPopoverProps$pan = cellPopoverProps.panelProps) === null || _cellPopoverProps$pan === void 0 ? void 0 : _cellPopoverProps$pan.className),
    onKeyDown: function onKeyDown(event) {
      if (event.key === _services.keys.F2 || event.key === _services.keys.ESCAPE) {
        event.preventDefault();
        event.stopPropagation();
        closeCellPopover();
        // Ensure focus is returned to the parent cell
        requestAnimationFrame(function () {
          return popoverAnchor.parentElement.focus();
        });
      }
    },
    button: popoverAnchor,
    closePopover: closeCellPopover
  }), popoverContent);
  return {
    cellPopoverContext: cellPopoverContext,
    cellPopover: cellPopover
  };
};

/**
 * Popover content renderers
 */
exports.useCellPopover = useCellPopover;
var DefaultCellPopover = function DefaultCellPopover(_ref2) {
  var schema = _ref2.schema,
    cellActions = _ref2.cellActions,
    children = _ref2.children,
    cellContentsElement = _ref2.cellContentsElement;
  switch (schema) {
    case 'json':
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(JsonPopoverContent, {
        cellText: cellContentsElement.innerText
      }), cellActions);
    default:
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_text.EuiText, null, children), cellActions);
  }
};
exports.DefaultCellPopover = DefaultCellPopover;
var JsonPopoverContent = function JsonPopoverContent(_ref3) {
  var cellText = _ref3.cellText;
  var formattedText = cellText;
  try {
    formattedText = JSON.stringify(JSON.parse(formattedText), null, 2);
  } catch (e) {}
  return (0, _react2.jsx)(_code.EuiCodeBlock, {
    isCopyable: true,
    transparentBackground: true,
    paddingSize: "none",
    language: "json"
  }, formattedText);
};
exports.JsonPopoverContent = JsonPopoverContent;