"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCommentEvent = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../services");
var _classnames = _interopRequireDefault(require("classnames"));
var _panel = require("../panel");
var _avatar = require("../avatar");
var _comment_event = require("./comment_event.styles");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiCommentEvent = function EuiCommentEvent(_ref) {
  var children = _ref.children,
    className = _ref.className,
    eventIcon = _ref.eventIcon,
    eventIconAriaLabel = _ref.eventIconAriaLabel,
    username = _ref.username,
    timestamp = _ref.timestamp,
    event = _ref.event,
    actions = _ref.actions,
    eventColor = _ref.eventColor;
  var classes = (0, _classnames.default)('euiCommentEvent', className);

  // the username is required so we only check if other elements are define
  var hasEventElements = eventIcon || timestamp || event || actions;
  var isTypeRegular = children && hasEventElements;
  var isTypeUpdate = !children && hasEventElements;
  var type;
  if (isTypeRegular) {
    type = 'regular';
  } else if (isTypeUpdate) {
    type = 'update';
  } else {
    type = 'custom';
  }
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _comment_event.euiCommentEventStyles)(euiTheme);
  var cssStyles = [styles.euiCommentEvent, styles[type]];
  var headerStyles = (0, _comment_event.euiCommentEventHeaderStyles)(euiTheme);
  var cssHeaderStyles = [headerStyles.euiCommentEvent__header, eventColor && headerStyles.hasEventColor, isTypeRegular && headerStyles.regular];
  var bodyStyles = (0, _comment_event.euiCommentEventBodyStyles)(euiTheme);
  var cssBodyStyles = [bodyStyles.euiCommentEvent__body, bodyStyles[type]];
  var isFigure = isTypeRegular;
  var Element = isFigure ? 'figure' : 'div';
  var HeaderElement = isFigure ? 'figcaption' : 'div';

  // The 'plain' color creates a shadow and adds a border radius that we don't want.
  // So for these cases we use the transparent color instead.
  var finalEventColor = eventColor === 'plain' ? 'transparent' : eventColor;
  var panelProps = finalEventColor ? {
    color: finalEventColor,
    paddingSize: 's'
  } : {
    color: 'transparent',
    paddingSize: 'none'
  };
  return (0, _react2.jsx)(Element, {
    className: classes,
    css: cssStyles,
    "data-type": type
  }, hasEventElements && (0, _react2.jsx)(HeaderElement, {
    className: "euiCommentEvent__header",
    css: cssHeaderStyles
  }, (0, _react2.jsx)(_panel.EuiPanel, panelProps, (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerMain",
    css: headerStyles.euiCommentEvent__headerMain
  }, (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerData",
    css: headerStyles.euiCommentEvent__headerData
  }, eventIcon && (0, _react2.jsx)(_avatar.EuiAvatar, {
    className: "euiCommentEvent__headerEventIcon",
    css: headerStyles.euiCommentEvent__headerEventIcon,
    size: "s",
    iconType: eventIcon,
    name: eventIconAriaLabel ? eventIconAriaLabel : '',
    color: "subdued",
    "aria-hidden": !eventIconAriaLabel
  }), username && (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerUsername",
    css: headerStyles.euiCommentEvent__headerUsername
  }, username), event && (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerEvent",
    css: headerStyles.euiCommentEvent__headerEvent
  }, event), timestamp && (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerTimestamp"
  }, (0, _react2.jsx)("time", null, timestamp))), actions && (0, _react2.jsx)("div", {
    className: "euiCommentEvent__headerActions",
    css: headerStyles.euiCommentEvent__headerActions
  }, actions)))), children && (0, _react2.jsx)("div", {
    className: "euiCommentEvent__body",
    css: cssBodyStyles
  }, children));
};
exports.EuiCommentEvent = EuiCommentEvent;
EuiCommentEvent.propTypes = {
  /**
     * Author of the comment.
     */
  username: _propTypes.default.node.isRequired,
  /**
     * Time of occurrence of the event. Its format is set on the consumer's side
     */
  timestamp: _propTypes.default.node,
  /**
     * Describes the event that took place
     */
  event: _propTypes.default.node,
  /**
     * Custom actions that the user can perform from the comment's header
     */
  actions: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired]),
  /**
     * Accepts any ReactNode. Renders in a panel within the comment event.
     */
  children: _propTypes.default.node,
  /**
     * Custom icon that shows before the username.
     */
  eventIcon: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "error", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "namespace", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDenseVector", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),
  /**
     * Specify an `aria-label` for the `eventIcon`.
     * If no `aria-label` is passed we assume the icon is purely decorative.
     */
  eventIconAriaLabel: _propTypes.default.string,
  /**
     * Background color for the comment's header.
     */
  eventColor: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};