"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiColorStopsStyles = exports.euiColorStopsAddContainerStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _form = require("../../form/form.styles");
var _range = require("../../form/range/range.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "uu65b3-isDragging",
  styles: "cursor:grabbing;label:isDragging;"
} : {
  name: "uu65b3-isDragging",
  styles: "cursor:grabbing;label:isDragging;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiColorStopsStyles = function euiColorStopsStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var isDarkMode = colorMode === 'DARK';
  var stripeColor = isDarkMode ? (0, _services.brighten)(range.trackColor, 0.5) : (0, _services.darken)(range.trackColor, 0.5);
  var stripesBackground = "repeating-linear-gradient(\n    -45deg,\n    ".concat(range.trackColor, ",\n    ").concat(range.trackColor, " 25%,\n    ").concat(stripeColor, " 25%,\n    ").concat(stripeColor, " 50%,\n    ").concat(range.trackColor, " 50%\n  )");
  return {
    // Base
    euiColorStops: /*#__PURE__*/(0, _react.css)(";label:euiColorStops;"),
    isEnabled: /*#__PURE__*/(0, _react.css)("&:focus{outline:none;}&:focus-visible{.euiColorStops__track::after{box-shadow:0 0 0 1px rgba(", (0, _services.hexToRgb)(euiTheme.colors.emptyShade).join(', '), ", 0.8),0 0 0 3px ", range.focusColor, ";}};label:isEnabled;"),
    isDisabled: /*#__PURE__*/(0, _react.css)(";label:isDisabled;"),
    isHoverDisabled: /*#__PURE__*/(0, _react.css)(";label:isHoverDisabled;"),
    isReadOnly: /*#__PURE__*/(0, _react.css)(";label:isReadOnly;"),
    isDragging: _ref2,
    euiColorStops__track: /*#__PURE__*/(0, _react.css)("&::after{background:", stripesBackground, ";background-size:", euiTheme.size.xs, " ", euiTheme.size.xs, ";};label:euiColorStops__track;"),
    euiColorStops__addTarget: /*#__PURE__*/(0, _react.css)((0, _form.euiCustomControl)(euiThemeContext, {
      type: 'round'
    }), ";", (0, _range.euiRangeThumbStyle)(euiThemeContext), ";position:absolute;inset-block-start:0;block-size:", range.thumbHeight, ";inline-size:", range.thumbHeight, ";background-color:", euiTheme.colors.lightestShade, ";pointer-events:none;opacity:0;border:", euiTheme.border.width.thin, " solid ", euiTheme.colors.darkShade, ";box-shadow:none;z-index:", range.thumbZIndex, ";", _global_styling.euiCanAnimate, "{transition:opacity ", euiTheme.animation.fast, " ease-in;};label:euiColorStops__addTarget;")
  };
};
exports.euiColorStopsStyles = euiColorStopsStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1173em8-isEnabled",
  styles: "&:hover{cursor:pointer;.euiColorStops__addTarget{opacity:0.7;}};label:isEnabled;"
} : {
  name: "1173em8-isEnabled",
  styles: "&:hover{cursor:pointer;.euiColorStops__addTarget{opacity:0.7;}};label:isEnabled;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiColorStopsAddContainerStyles = function euiColorStopsAddContainerStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    euiColorStopsAddContainer: /*#__PURE__*/(0, _react.css)("display:block;position:absolute;inset-inline-start:0;inset-inline-end:0;inset-block-start:50%;block-size:", range.thumbHeight, ";margin-block-start:", (0, _global_styling.mathWithUnits)(range.thumbHeight, function (x) {
      return x * -0.5;
    }), ";z-index:", range.thumbZIndex, ";;label:euiColorStopsAddContainer;"),
    isEnabled: _ref,
    isDisabled: /*#__PURE__*/(0, _react.css)(";label:isDisabled;")
  };
};
exports.euiColorStopsAddContainerStyles = euiColorStopsAddContainerStyles;