"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiColorStopThumbStyles = exports.euiColorStopThumbPopoverStyles = exports.euiColorStopStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _range = require("../../form/range/range.styles");
var _color_picker = require("../color_picker.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "zrzkfg-euiColorStopThumb",
  styles: "&:not(:disabled){inset-block-start:0;margin-block-start:0;pointer-events:auto;cursor:grab;&:active{cursor:grabbing;}};label:euiColorStopThumb;"
} : {
  name: "zrzkfg-euiColorStopThumb",
  styles: "&:not(:disabled){inset-block-start:0;margin-block-start:0;pointer-events:auto;cursor:grab;&:active{cursor:grabbing;}};label:euiColorStopThumb;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiColorStopThumbStyles = function euiColorStopThumbStyles(euiThemeContext) {
  return {
    // Base
    euiColorStopThumb: _ref2,
    isPopoverOpen: /*#__PURE__*/(0, _react.css)((0, _range.euiRangeThumbFocus)(euiThemeContext), ";;label:isPopoverOpen;")
  };
};
exports.euiColorStopThumbStyles = euiColorStopThumbStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1wndm4s-isLoadingPanel",
  styles: "visibility:hidden!important;label:isLoadingPanel;"
} : {
  name: "1wndm4s-isLoadingPanel",
  styles: "visibility:hidden!important;label:isLoadingPanel;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiColorStopThumbPopoverStyles = function euiColorStopThumbPopoverStyles(euiThemeContext) {
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiColorStopThumbPopover: /*#__PURE__*/(0, _react.css)("position:absolute;inset-block-start:50%;inline-size:", range.thumbWidth, ";block-size:", range.thumbHeight, ";margin-block-start:", (0, _global_styling.mathWithUnits)(range.thumbHeight, function (x) {
      return x * -0.5;
    }), ";.euiColorStopThumbPopover__anchor{position:absolute;inline-size:100%;block-size:100%;&::before{content:'';display:block;position:absolute;inset-inline-start:0;inset-block-start:0;block-size:", range.thumbHeight, ";inline-size:", range.thumbWidth, ";border-radius:", range.thumbHeight, ";background:", euiTheme.colors.emptyShade, ";}};label:euiColorStopThumbPopover;"),
    isLoadingPanel: _ref,
    hasFocus: /*#__PURE__*/(0, _react.css)("z-index:", range.thumbZIndex, ";;label:hasFocus;")
  };
};
exports.euiColorStopThumbPopoverStyles = euiColorStopThumbPopoverStyles;
var euiColorStopStyles = function euiColorStopStyles(euiThemeContext) {
  var colorPicker = (0, _color_picker.euiColorPickerVariables)(euiThemeContext);
  return {
    // Base
    euiColorStop: /*#__PURE__*/(0, _react.css)("inline-size:", colorPicker.width, ";;label:euiColorStop;")
  };
};
exports.euiColorStopStyles = euiColorStopStyles;