"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCodeBlockVirtualized = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactWindow = require("react-window");
var _global_styling = require("../../global_styling");
var _auto_sizer = require("../auto_sizer");
var _utils = require("./utils");
var _react2 = require("@emotion/react");
var _excluded = ["style"],
  _excluded2 = ["style"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiCodeBlockVirtualized = function EuiCodeBlockVirtualized(_ref) {
  var data = _ref.data,
    rowHeight = _ref.rowHeight,
    overflowHeight = _ref.overflowHeight,
    preProps = _ref.preProps,
    codeProps = _ref.codeProps;
  var VirtualizedOuterElement = (0, _react.useMemo)(function () {
    return /*#__PURE__*/(0, _react.forwardRef)(function (_ref2, ref) {
      var style = _ref2.style,
        props = _objectWithoutProperties(_ref2, _excluded);
      return (0, _react2.jsx)("pre", _extends({
        style: (0, _global_styling.logicalStyles)(style)
      }, props, {
        ref: ref
      }, preProps));
    });
  }, [preProps]);
  var VirtualizedInnerElement = (0, _react.useMemo)(function () {
    return /*#__PURE__*/(0, _react.forwardRef)(function (_ref3, ref) {
      var style = _ref3.style,
        props = _objectWithoutProperties(_ref3, _excluded2);
      return (0, _react2.jsx)("code", _extends({
        style: (0, _global_styling.logicalStyles)(style)
      }, props, {
        ref: ref
      }, codeProps));
    });
  }, [codeProps]);
  return (0, _react2.jsx)(_auto_sizer.EuiAutoSizer, {
    disableHeight: typeof overflowHeight === 'number'
  }, function (_ref4) {
    var height = _ref4.height,
      width = _ref4.width;
    return (0, _react2.jsx)(_reactWindow.FixedSizeList, {
      height: height !== null && height !== void 0 ? height : overflowHeight,
      width: width,
      itemData: data,
      itemSize: rowHeight,
      itemCount: data.length,
      outerElementType: VirtualizedOuterElement,
      innerElementType: VirtualizedInnerElement
    }, ListRow);
  });
};
exports.EuiCodeBlockVirtualized = EuiCodeBlockVirtualized;
var ListRow = function ListRow(_ref5) {
  var data = _ref5.data,
    index = _ref5.index,
    style = _ref5.style;
  var row = data[index];
  row.properties.style = (0, _global_styling.logicalStyles)(style);
  return (0, _utils.nodeToHtml)(row, index, data, 0);
};