"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCallOutStyles = exports.euiCallOutHeadingStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiCallOutStyles = function euiCallOutStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    euiCallOut: /*#__PURE__*/(0, _react.css)(";label:euiCallOut;"),
    euiCallOut__icon: /*#__PURE__*/(0, _react.css)("position:relative;", (0, _global_styling.logicalCSS)('top', '-1px'), ";", (0, _global_styling.logicalCSS)('margin-right', euiTheme.size.s), ";;label:euiCallOut__icon;"),
    euiCallOut__description: /*#__PURE__*/(0, _react.css)(":not(:only-child){", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.s), ";};label:euiCallOut__description;")
  };
};
exports.euiCallOutStyles = euiCallOutStyles;
var euiCallOutHeadingStyles = function euiCallOutHeadingStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiCallOutHeader: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.medium, ";", (0, _global_styling.logicalCSS)('margin-bottom', '0 !important'
    // In case it's nested inside EuiText
    ), ";;label:euiCallOutHeader;"),
    primary: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.primaryText, ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.successText, ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.warningText, ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)("color:", euiTheme.colors.dangerText, ";;label:danger;")
  };
};
exports.euiCallOutHeadingStyles = euiCallOutHeadingStyles;