"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sizeToClassNameMap = exports.colorToClassNameMap = exports.SIZES = exports.EuiButtonDisplayDeprecated = exports.EuiButton = exports.COLORS = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _button_content_deprecated = require("./_button_content_deprecated");
var _button = require("../../themes/amsterdam/global_styling/mixins/button");
var _button_display = require("./button_display/_button_display");
var _services = require("../../services");
var _react2 = require("@emotion/react");
var _excluded = ["buttonRef", "color", "fill"],
  _excluded2 = ["element", "baseClassName", "children", "className", "iconType", "iconSide", "color", "size", "isDisabled", "isLoading", "isSelected", "contentProps", "textProps", "fullWidth", "minWidth", "style"];
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; } /*
                                                                                                                                                                                     * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                     * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                     * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                     * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                     * Side Public License, v 1.
                                                                                                                                                                                     */
var COLORS = [].concat(_toConsumableArray(_button.BUTTON_COLORS), ['ghost']);
exports.COLORS = COLORS;
var SIZES = ['s', 'm'];
exports.SIZES = SIZES;
/**
 * EuiButton is largely responsible for providing relevant props
 * and the logic for element-specific attributes
 */
var EuiButton = function EuiButton(props) {
  var buttonRef = props.buttonRef,
    _props$color = props.color,
    _color = _props$color === void 0 ? 'primary' : _props$color,
    fill = props.fill,
    rest = _objectWithoutProperties(props, _excluded);
  var buttonIsDisabled = (0, _button_display.isButtonDisabled)({
    href: rest.href,
    isDisabled: rest.isDisabled || rest.disabled,
    isLoading: rest.isLoading
  });
  var color = buttonIsDisabled ? 'disabled' : _color;
  var buttonColorStyles = (0, _button.useEuiButtonColorCSS)({
    display: fill ? 'fill' : 'base'
  })[color === 'ghost' ? 'text' : color];
  var buttonFocusStyle = (0, _button.useEuiButtonFocusCSS)();
  var cssStyles = [buttonColorStyles, buttonFocusStyle];
  if (_color === 'ghost') {
    // INCEPTION: If `ghost`, re-implement with a wrapping dark mode theme provider
    return (0, _react2.jsx)(_services.EuiThemeProvider, {
      colorMode: "dark",
      wrapperProps: {
        cloneElement: true
      }
    }, (0, _react2.jsx)(EuiButton, _extends({}, props, {
      color: "text"
    })));
  }
  return (0, _react2.jsx)(_button_display.EuiButtonDisplay, _extends({
    className: "euiButton",
    ref: buttonRef,
    css: cssStyles
  }, rest));
};
exports.EuiButton = EuiButton;
EuiButton.propTypes = {
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  children: _propTypes.default.node,
  /**
     * Make button a solid color for prominence
     */
  /**
     * Make button a solid color for prominence
     */
  fill: _propTypes.default.bool,
  /**
     * Any of the named color palette options.
     * **`'ghost'` is set for deprecation. Use EuiThemeProvide.colorMode = 'dark' instead.**
     */
  /**
     * Any of the named color palette options.
     * **`'ghost'` is set for deprecation. Use EuiThemeProvide.colorMode = 'dark' instead.**
     */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf(["ghost"])]),
  /**
     * Use size `s` in confined spaces
     */
  /**
     * Use size `s` in confined spaces
     */
  size: _propTypes.default.any,
  /**
     * `disabled` is also allowed
     */
  /**
     * `disabled` is also allowed
     */
  isDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  buttonRef: _propTypes.default.any
};
EuiButton.displayName = 'EuiButton';

// Use defaultProps for simple pass-through props
EuiButton.defaultProps = {
  size: 'm',
  color: 'primary'
};
var sizeToClassNameMap = {
  s: '--small',
  m: null
};
exports.sizeToClassNameMap = sizeToClassNameMap;
var colorToClassNameMap = {
  primary: '--primary',
  accent: '--accent',
  success: '--success',
  warning: '--warning',
  danger: '--danger',
  ghost: '--ghost',
  text: '--text'
};

/**
 * *DEPRECATED*
 * EuiButtonDisplay is an internal-only component used for displaying
 * any element as a button.
 * NOTE: This component *must* be below EuiButton in the file and
 * EuiButton must also set a displayName for react-docgen-typescript
 * to correctly set EuiButton's docgenInfo and display a props table.
 * This component has been deprecated in favor of the new EuiButtonDisplay
 * that can be found in `src/components/button/button_display/_button_display.tsx`
 */
exports.colorToClassNameMap = colorToClassNameMap;
var EuiButtonDisplayDeprecated = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var _ref$element = _ref.element,
    element = _ref$element === void 0 ? 'button' : _ref$element,
    baseClassName = _ref.baseClassName,
    children = _ref.children,
    className = _ref.className,
    iconType = _ref.iconType,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'left' : _ref$iconSide,
    color = _ref.color,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    isDisabled = _ref.isDisabled,
    isLoading = _ref.isLoading,
    isSelected = _ref.isSelected,
    contentProps = _ref.contentProps,
    textProps = _ref.textProps,
    fullWidth = _ref.fullWidth,
    minWidth = _ref.minWidth,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded2);
  var buttonIsDisabled = (0, _button_display.isButtonDisabled)({
    isLoading: isLoading,
    isDisabled: isDisabled
  });
  var classes = (0, _classnames.default)(baseClassName, color && colorToClassNameMap[color] ? "".concat(baseClassName).concat(colorToClassNameMap[color]) : undefined, size && sizeToClassNameMap[size] ? "".concat(baseClassName).concat(sizeToClassNameMap[size]) : null, fullWidth && "".concat(baseClassName, "--fullWidth"), className);

  /**
   * Not changing the content or text class names to match baseClassName yet,
   * as it is a major breaking change.
   */
  var contentClassNames = (0, _classnames.default)('euiButton__content', contentProps && contentProps.className);
  var textClassNames = (0, _classnames.default)('euiButton__text', textProps && textProps.className);
  var innerNode = (0, _react2.jsx)(_button_content_deprecated.EuiButtonContentDeprecated, _extends({
    isLoading: isLoading,
    iconType: iconType,
    iconSide: iconSide,
    textProps: _objectSpread(_objectSpread({}, textProps), {}, {
      className: textClassNames
    })
  }, contentProps, {
    // className has to come last to override contentProps.className
    className: contentClassNames
  }), children);
  var calculatedStyle = style;
  if (minWidth !== undefined || minWidth !== null) {
    calculatedStyle = _objectSpread(_objectSpread({}, calculatedStyle), {}, {
      // @ts-ignore - deprecated component
      minWidth: minWidth
    });
  }
  return /*#__PURE__*/_react.default.createElement(element, _objectSpread({
    className: classes,
    style: calculatedStyle,
    disabled: element === 'button' && buttonIsDisabled,
    'aria-pressed': element === 'button' ? isSelected : undefined,
    ref: ref
  }, rest), innerNode);
});
exports.EuiButtonDisplayDeprecated = EuiButtonDisplayDeprecated;
EuiButtonDisplayDeprecated.propTypes = {
  children: _propTypes.default.node,
  /**
     * Make button a solid color for prominence
     */
  fill: _propTypes.default.bool,
  /**
     * Any of the named color palette options.
     * **`'ghost'` is set for deprecation. Use EuiThemeProvide.colorMode = 'dark' instead.**
     */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf(["ghost"])]),
  /**
     * Use size `s` in confined spaces
     */
  size: _propTypes.default.any,
  /**
     * `disabled` is also allowed
     */
  isDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Provide a valid element to render the element as
       */
  element: _propTypes.default.oneOf(["a", "button", "span", "label"]).isRequired,
  /**
       * Provide the component's base class name to build the class list on
       */
  baseClassName: _propTypes.default.string.isRequired
};
EuiButtonDisplayDeprecated.displayName = 'EuiButtonDisplay';