"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiBreadcrumbContent = exports.EuiBreadcrumbCollapsed = exports.EuiBreadcrumb = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _text = require("../text");
var _link = require("../link");
var _popover = require("../popover");
var _icon = require("../icon");
var _i18n = require("../i18n");
var _breadcrumb = require("./breadcrumb.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "type", "truncate"],
  _excluded2 = ["text", "truncate", "type", "href", "rel", "onClick", "className", "color", "isFirstBreadcrumb", "isLastBreadcrumb", "isOnlyBreadcrumb", "highlightLastBreadcrumb", "truncateLastBreadcrumb"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Used internally only by the parent EuiBreadcrumbs
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiBreadcrumb = function EuiBreadcrumb(_ref) {
  var children = _ref.children,
    className = _ref.className,
    type = _ref.type,
    truncate = _ref.truncate,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiBreadcrumb', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _breadcrumb.euiBreadcrumbStyles)(euiTheme);
  var cssStyles = [styles.euiBreadcrumb, styles[type], truncate && styles.isTruncated];
  return (0, _react2.jsx)("li", _extends({
    className: classes,
    css: cssStyles,
    "data-test-subj": "euiBreadcrumb"
  }, rest), children);
};
exports.EuiBreadcrumb = EuiBreadcrumb;
EuiBreadcrumb.propTypes = {
  type: _propTypes.default.oneOf(["page", "application"]).isRequired,
  isFirstBreadcrumb: _propTypes.default.bool,
  isLastBreadcrumb: _propTypes.default.bool,
  isOnlyBreadcrumb: _propTypes.default.bool,
  highlightLastBreadcrumb: _propTypes.default.bool,
  truncateLastBreadcrumb: _propTypes.default.bool
};
var EuiBreadcrumbContent = function EuiBreadcrumbContent(_ref2) {
  var text = _ref2.text,
    truncate = _ref2.truncate,
    type = _ref2.type,
    href = _ref2.href,
    rel = _ref2.rel,
    onClick = _ref2.onClick,
    className = _ref2.className,
    color = _ref2.color,
    isFirstBreadcrumb = _ref2.isFirstBreadcrumb,
    isLastBreadcrumb = _ref2.isLastBreadcrumb,
    isOnlyBreadcrumb = _ref2.isOnlyBreadcrumb,
    highlightLastBreadcrumb = _ref2.highlightLastBreadcrumb,
    truncateLastBreadcrumb = _ref2.truncateLastBreadcrumb,
    rest = _objectWithoutProperties(_ref2, _excluded2);
  var classes = (0, _classnames.default)('euiBreadcrumb__content', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _breadcrumb.euiBreadcrumbContentStyles)(euiTheme);
  var cssStyles = [styles.euiBreadcrumb__content, styles[type], truncate && !truncateLastBreadcrumb && styles.isTruncated, truncateLastBreadcrumb && styles.isTruncatedLast];
  if (type === 'application') {
    if (isOnlyBreadcrumb) {
      cssStyles.push(styles.applicationStyles.onlyChild);
    } else if (isFirstBreadcrumb) {
      cssStyles.push(styles.applicationStyles.firstChild);
    } else if (isLastBreadcrumb) {
      cssStyles.push(styles.applicationStyles.lastChild);
    }
  }
  var ariaCurrent = highlightLastBreadcrumb ? 'page' : undefined;
  return (0, _react2.jsx)(_inner_text.EuiInnerText, null, function (ref, innerText) {
    var title = innerText === '' ? undefined : innerText;
    return !href && !onClick ? (0, _react2.jsx)(_text.EuiTextColor, {
      color: highlightLastBreadcrumb ? 'default' : 'subdued',
      cloneElement: true
    }, (0, _react2.jsx)("span", _extends({
      ref: ref,
      title: title,
      "aria-current": ariaCurrent,
      className: classes,
      css: cssStyles
    }, rest), text)) : (0, _react2.jsx)(_link.EuiLink, _extends({
      ref: ref,
      title: title,
      "aria-current": ariaCurrent,
      className: classes,
      css: cssStyles,
      color: color || (highlightLastBreadcrumb ? 'text' : 'subdued'),
      onClick: onClick,
      href: href,
      rel: rel
    }, rest), text);
  });
};
exports.EuiBreadcrumbContent = EuiBreadcrumbContent;
EuiBreadcrumbContent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  href: _propTypes.default.string,
  rel: _propTypes.default.string,
  onClick: _propTypes.default.func,
  /**
       * Visible label of the breadcrumb
       */
  text: _propTypes.default.node.isRequired,
  /**
       * Force a max-width on the breadcrumb text
       */
  truncate: _propTypes.default.bool,
  /**
       * Accepts any EuiLink `color` when rendered as one (has `href` or `onClick`)
       */
  color: _propTypes.default.any,
  /**
       * Override the existing `aria-current` which defaults to `page` for the last breadcrumb
       */
  "aria-current": _propTypes.default.any,
  type: _propTypes.default.oneOf(["page", "application"]).isRequired,
  isFirstBreadcrumb: _propTypes.default.bool,
  isLastBreadcrumb: _propTypes.default.bool,
  isOnlyBreadcrumb: _propTypes.default.bool,
  highlightLastBreadcrumb: _propTypes.default.bool,
  truncateLastBreadcrumb: _propTypes.default.bool
};
var EuiBreadcrumbCollapsed = function EuiBreadcrumbCollapsed(_ref3) {
  var children = _ref3.children,
    isFirstBreadcrumb = _ref3.isFirstBreadcrumb,
    type = _ref3.type;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _breadcrumb.euiBreadcrumbStyles)(euiTheme);
  var cssStyles = [styles.isCollapsed];
  var ariaLabel = (0, _i18n.useEuiI18n)('euiBreadcrumb.collapsedBadge.ariaLabel', 'See collapsed breadcrumbs');
  var ellipsisButton = (0, _react2.jsx)(EuiBreadcrumbContent, {
    "aria-label": ariaLabel,
    title: ariaLabel,
    onClick: function onClick() {
      return setIsPopoverOpen(!isPopoverOpen);
    },
    truncate: false,
    text: (0, _react2.jsx)(_react.default.Fragment, null, "\u2026 ", (0, _react2.jsx)(_icon.EuiIcon, {
      type: "arrowDown",
      size: "s"
    })),
    isFirstBreadcrumb: isFirstBreadcrumb,
    type: type
  });
  return (0, _react2.jsx)(EuiBreadcrumb, {
    css: cssStyles,
    type: type
  }, (0, _react2.jsx)(_popover.EuiPopover, {
    button: ellipsisButton,
    isOpen: isPopoverOpen,
    closePopover: function closePopover() {
      return setIsPopoverOpen(false);
    }
  }, children));
};
exports.EuiBreadcrumbCollapsed = EuiBreadcrumbCollapsed;
EuiBreadcrumbCollapsed.propTypes = {
  type: _propTypes.default.oneOf(["page", "application"]).isRequired,
  isFirstBreadcrumb: _propTypes.default.bool,
  isLastBreadcrumb: _propTypes.default.bool,
  isOnlyBreadcrumb: _propTypes.default.bool,
  highlightLastBreadcrumb: _propTypes.default.bool,
  truncateLastBreadcrumb: _propTypes.default.bool
};