"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.EuiNotificationBadge = exports.COLORS = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _badge_notification = require("./badge_notification.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "size", "color"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var COLORS = ['accent', 'subdued'];
exports.COLORS = COLORS;
var SIZES = ['s', 'm'];
exports.SIZES = SIZES;
var EuiNotificationBadge = function EuiNotificationBadge(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'accent' : _ref$color,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _badge_notification.euiNotificationBadgeStyles)(euiTheme);
  var cssStyles = [styles.euiNotificationBadge, styles[size], styles[color]];
  var classes = (0, _classnames.default)('euiNotificationBadge', className);
  return (0, _react2.jsx)("span", _extends({
    css: cssStyles,
    className: classes
  }, rest), children);
};
exports.EuiNotificationBadge = EuiNotificationBadge;
EuiNotificationBadge.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node.isRequired,
  size: _propTypes.default.any,
  color: _propTypes.default.any,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};