"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiAccordionTriggerWrapperStyles = exports.euiAccordionSpinnerStyles = exports.euiAccordionOptionalActionStyles = exports.euiAccordionIconButtonStyles = exports.euiAccordionChildrenStyles = exports.euiAccordionChildWrapperStyles = exports.euiAccordionButtonStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
                                                                                                                                                                                                                                                                                           * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                           * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                           * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                           * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                           * Side Public License, v 1.
                                                                                                                                                                                                                                                                                           */
var euiAccordionButtonStyles = function euiAccordionButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiAccordion__button: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 's'), ";align-items:center;display:flex;flex-grow:1;line-height:", euiTheme.size.l, ";", (0, _global_styling.logicalTextAlignCSS)('left'), " ", (0, _global_styling.logicalCSS)('width', '100%'), " &:hover,&:focus{cursor:pointer;text-decoration:underline;};label:euiAccordion__button;"),
    // Triggering button needs separate `disabled` key because the element that renders may not support `:disabled`;
    // Hover pseudo selector for specificity
    disabled: /*#__PURE__*/(0, _react.css)("&,&:hover{cursor:not-allowed;color:", euiTheme.colors.disabledText, ";text-decoration:none;};label:disabled;")
  };
};
exports.euiAccordionButtonStyles = euiAccordionButtonStyles;
var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1xvjonu-isLoading",
  styles: "align-items:center;display:flex;label:isLoading;"
} : {
  name: "1xvjonu-isLoading",
  styles: "align-items:center;display:flex;label:isLoading;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiAccordionChildrenStyles = function euiAccordionChildrenStyles(_ref5) {
  var euiTheme = _ref5.euiTheme;
  return {
    euiAccordion__children: /*#__PURE__*/(0, _react.css)(";label:euiAccordion__children;"),
    isLoading: _ref4,
    xs: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.xs, ";;label:xs;"),
    s: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.base, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.l, ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.xl, ";;label:xl;")
  };
};
exports.euiAccordionChildrenStyles = euiAccordionChildrenStyles;
var euiAccordionChildWrapperStyles = function euiAccordionChildWrapperStyles(_ref6) {
  var euiTheme = _ref6.euiTheme;
  return {
    euiAccordion__childWrapper: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', 0), " opacity:0;overflow:hidden;transition:", _global_styling.logicals.height, " ", euiTheme.animation.normal, " ", euiTheme.animation.resistance, ",opacity ", euiTheme.animation.normal, " ", euiTheme.animation.resistance, ";visibility:hidden;&:focus{outline:none;};label:euiAccordion__childWrapper;"),
    isOpen: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', 'auto'), " opacity:1;visibility:visible;;label:isOpen;")
  };
};
exports.euiAccordionChildWrapperStyles = euiAccordionChildWrapperStyles;
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "pbbcf-isOpen",
  styles: "transform:rotate(90deg)!important;label:isOpen;"
} : {
  name: "pbbcf-isOpen",
  styles: "transform:rotate(90deg)!important;label:isOpen;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiAccordionIconButtonStyles = function euiAccordionIconButtonStyles(_ref7) {
  var euiTheme = _ref7.euiTheme;
  return {
    euiAccordion__iconButton: /*#__PURE__*/(0, _react.css)("flex-shrink:0;", (0, _global_styling.logicalCSS)('margin-right', euiTheme.size.xs), " transform:rotate(0deg)!important;;label:euiAccordion__iconButton;"),
    isOpen: _ref3,
    arrowRight: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('margin-right', 0), ";;label:arrowRight;")
  };
};
exports.euiAccordionIconButtonStyles = euiAccordionIconButtonStyles;
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "iqfpv3-euiAccordion__optionalAction",
  styles: "flex-shrink:0;label:euiAccordion__optionalAction;"
} : {
  name: "iqfpv3-euiAccordion__optionalAction",
  styles: "flex-shrink:0;label:euiAccordion__optionalAction;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiAccordionOptionalActionStyles = function euiAccordionOptionalActionStyles() {
  return {
    euiAccordion__optionalAction: _ref2
  };
};
exports.euiAccordionOptionalActionStyles = euiAccordionOptionalActionStyles;
var euiAccordionSpinnerStyles = function euiAccordionSpinnerStyles(_ref8) {
  var euiTheme = _ref8.euiTheme;
  return {
    euiAccordion__spinner: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-right', euiTheme.size.xs), ";;label:euiAccordion__spinner;")
  };
};
exports.euiAccordionSpinnerStyles = euiAccordionSpinnerStyles;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1r6c0fv-euiAccordion__triggerWrapper",
  styles: "align-items:center;display:flex;label:euiAccordion__triggerWrapper;"
} : {
  name: "1r6c0fv-euiAccordion__triggerWrapper",
  styles: "align-items:center;display:flex;label:euiAccordion__triggerWrapper;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiAccordionTriggerWrapperStyles = function euiAccordionTriggerWrapperStyles() {
  return {
    euiAccordion__triggerWrapper: _ref
  };
};
exports.euiAccordionTriggerWrapperStyles = euiAccordionTriggerWrapperStyles;