"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TooltipTableColorCell = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
const tooltip_provider_1 = require("./tooltip_provider");
const tooltip_table_cell_1 = require("./tooltip_table_cell");
const color_calcs_1 = require("../../../common/color_calcs");
const color_library_wrappers_1 = require("../../../common/color_library_wrappers");
const colors_1 = require("../../../common/colors");
function TooltipTableColorCell({ color, className, displayOnly, ...cellProps }) {
    const { backgroundColor, theme } = (0, tooltip_provider_1.useTooltipContext)();
    const getDotColor = (stripColor) => {
        if (color === colors_1.Colors.Transparent.keyword) {
            return theme.defaultDotColor;
        }
        const foregroundRGBA = (0, color_library_wrappers_1.colorToRgba)(stripColor === colors_1.Colors.Transparent.keyword ? backgroundColor : stripColor);
        const backgroundRGBA = (0, color_library_wrappers_1.colorToRgba)(backgroundColor);
        const blendedFgBg = (0, color_calcs_1.combineColors)(foregroundRGBA, backgroundRGBA);
        return (0, color_library_wrappers_1.RGBATupleToString)((0, color_calcs_1.highContrastColor)(blendedFgBg, 'WCAG3'));
    };
    const renderColorStrip = () => {
        if (!color)
            return null;
        const dotColor = getDotColor(color);
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("div", { className: "echTooltip__colorStrip--bg", style: { backgroundColor } }),
            react_1.default.createElement("div", { className: "echTooltip__colorStrip", style: { backgroundColor: color, color: dotColor } }),
            react_1.default.createElement("div", { className: "echTooltip__colorStrip--spacer" })));
    };
    return (react_1.default.createElement(tooltip_table_cell_1.TooltipTableCell, { ...cellProps, className: (0, classnames_1.default)('echTooltip__colorCell', className, {
            'echTooltip__colorCell--static': displayOnly,
        }) }, renderColorStrip()));
}
exports.TooltipTableColorCell = TooltipTableColorCell;
//# sourceMappingURL=tooltip_table_color_cell.js.map