"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderTimeUnitAnnotation = void 0;
const predicate_1 = require("../../../../../common/predicate");
const locale_translations_1 = require("../../../../xy_chart/axes/timeslip/locale_translations");
const multilayer_ticks_1 = require("../../../../xy_chart/axes/timeslip/multilayer_ticks");
function renderTimeUnitAnnotation(ctx, config, binUnitCount, binUnit, chartTopFontSize, yOffset, unitBarMaxWidthPixels) {
    const locale = (0, predicate_1.hasKey)(locale_translations_1.LOCALE_TRANSLATIONS, config.locale)
        ? config.locale
        : multilayer_ticks_1.DEFAULT_LOCALE;
    const unitBarY = yOffset - chartTopFontSize * 1.7;
    ctx.save();
    ctx.textBaseline = 'bottom';
    ctx.textAlign = 'left';
    ctx.font = config.monospacedFontShorthand;
    ctx.fillStyle = config.a11y.contrast === 'low' ? config.subduedFontColor : config.defaultFontColor;
    ctx.fillText(`1 ${locale_translations_1.LOCALE_TRANSLATIONS[locale].bar} = ${binUnitCount} ${locale_translations_1.LOCALE_TRANSLATIONS[locale][binUnit][binUnitCount === 1 ? 0 : 1]}`, 0, yOffset);
    ctx.fillRect(0, unitBarY, unitBarMaxWidthPixels, 1);
    ctx.fillRect(0, unitBarY - 3, 1, 7);
    ctx.fillRect(unitBarMaxWidthPixels - 1, unitBarY - 3, 1, 7);
    ctx.restore();
}
exports.renderTimeUnitAnnotation = renderTimeUnitAnnotation;
//# sourceMappingURL=time_unit.js.map