"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderWrappedPartitionCanvas2d = void 0;
const MAX_PADDING_RATIO = 0.25;
function renderWrappedPartitionCanvas2d(ctx, dpr, { style: { sectorLineWidth: padding }, quadViewModel, diskCenter, width: panelWidth, height: panelHeight, chartDimensions: { width: containerWidth, height: containerHeight }, }) {
    const width = containerWidth * panelWidth;
    const height = containerHeight * panelHeight;
    const cornerRatio = 0.2;
    ctx.save();
    ctx.textAlign = 'left';
    ctx.textBaseline = 'middle';
    ctx.lineCap = 'round';
    ctx.lineJoin = 'round';
    ctx.scale(dpr, dpr);
    ctx.translate(diskCenter.x, diskCenter.y);
    ctx.clearRect(0, 0, width, height);
    quadViewModel.forEach(({ fillColor, x0, x1, y0px: y0, y1px: y1 }) => {
        if (y1 - y0 <= padding)
            return;
        const fWidth = x1 - x0;
        const fPadding = Math.min(padding, MAX_PADDING_RATIO * fWidth);
        const paintedWidth = fWidth - fPadding;
        const paintedHeight = y1 - y0 - padding;
        const cornerRadius = 2 * cornerRatio * Math.min(paintedWidth, paintedHeight);
        const halfRadius = cornerRadius / 2;
        ctx.fillStyle = fillColor;
        ctx.strokeStyle = fillColor;
        ctx.lineWidth = cornerRadius;
        ctx.beginPath();
        ctx.rect(x0 + fPadding + halfRadius, y0 + padding / 2 + halfRadius, paintedWidth - cornerRadius, paintedHeight - cornerRadius);
        ctx.fill();
        ctx.stroke();
    });
    ctx.restore();
}
exports.renderWrappedPartitionCanvas2d = renderWrappedPartitionCanvas2d;
//# sourceMappingURL=canvas_wrapped_renderers.js.map