"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonWatchEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _execute_details = require("../../../../models/execute_details");
var _get_action_type = require("../../../../../../common/lib/get_action_type");
var _constants = require("../../../../../../common/constants");
var _json_watch_edit_form = require("./json_watch_edit_form");
var _json_watch_edit_simulate = require("./json_watch_edit_simulate");
var _watch_context = require("../../watch_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WATCH_EDIT_TAB = 'watchEditTab';
const WATCH_SIMULATE_TAB = 'watchSimulateTab';
const WATCH_TABS = [{
  id: WATCH_EDIT_TAB,
  name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.editTabLabel', {
    defaultMessage: 'Edit'
  })
}, {
  id: WATCH_SIMULATE_TAB,
  name: _i18n.i18n.translate('xpack.watcher.sections.watchEdit.json.simulateTabLabel', {
    defaultMessage: 'Simulate'
  })
}];
const EXECUTE_DETAILS_INITIAL_STATE = {
  triggeredTimeValue: 0,
  triggeredTimeUnit: _constants.TIME_UNITS.SECOND,
  scheduledTimeValue: 0,
  scheduledTimeUnit: _constants.TIME_UNITS.SECOND,
  ignoreCondition: false
};
function getActions(watch) {
  const actions = watch.watch && watch.watch.actions || {};
  return Object.keys(actions).map(actionKey => ({
    actionId: actionKey,
    type: (0, _get_action_type.getActionType)(actions[actionKey]),
    actionMode: _constants.ACTION_MODES.SIMULATE
  }));
}
function getActionModes(items) {
  const result = items.reduce((itemsAccum, item) => {
    if (item.actionId) {
      itemsAccum[item && item.actionId] = item.actionMode;
    }
    return itemsAccum;
  }, {});
  return result;
}
const JsonWatchEdit = ({
  pageTitle
}) => {
  const {
    watch
  } = (0, _react.useContext)(_watch_context.WatchContext);
  const watchActions = getActions(watch);
  // hooks
  const [selectedTab, setSelectedTab] = (0, _react.useState)(WATCH_EDIT_TAB);
  const [executeDetails, setExecuteDetails] = (0, _react.useState)(new _execute_details.ExecuteDetails({
    ...EXECUTE_DETAILS_INITIAL_STATE,
    actionModes: getActionModes(watchActions)
  }));
  const executeWatchErrors = executeDetails.validate();
  const hasExecuteWatchErrors = !!Object.keys(executeWatchErrors).find(errorKey => executeWatchErrors[errorKey].length >= 1);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentBody_Deprecated, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle"
    }, pageTitle),
    bottomBorder: true,
    tabs: WATCH_TABS.map((tab, index) => ({
      onClick: () => {
        setSelectedTab(tab.id);
        setExecuteDetails(new _execute_details.ExecuteDetails({
          ...executeDetails,
          actionModes: getActionModes(watchActions)
        }));
      },
      isSelected: tab.id === selectedTab,
      key: index,
      'data-test-subj': 'tab',
      label: tab.name
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), selectedTab === WATCH_SIMULATE_TAB && /*#__PURE__*/_react.default.createElement(_json_watch_edit_simulate.JsonWatchEditSimulate, {
    executeDetails: executeDetails,
    setExecuteDetails: details => setExecuteDetails(details),
    executeWatchErrors: executeWatchErrors,
    hasExecuteWatchErrors: hasExecuteWatchErrors,
    watchActions: watchActions
  }), selectedTab === WATCH_EDIT_TAB && /*#__PURE__*/_react.default.createElement(_json_watch_edit_form.JsonWatchEditForm, null));
};
exports.JsonWatchEdit = JsonWatchEdit;