"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("./shared_imports");
var _app = require("./app");
var _api = require("./lib/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderApp = bootDeps => {
  const {
    I18nContext,
    element,
    theme$,
    ...appDeps
  } = bootDeps;
  (0, _api.setHttpClient)(appDeps.http);
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      uiSettings: bootDeps.uiSettings,
      settings: bootDeps.settings,
      theme: bootDeps.theme
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_app.App, appDeps)))), element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(element);
  };
};
exports.renderApp = renderApp;