"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationsPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _capabilities_provider = require("./capabilities_provider");
var _content_management = require("./content_management");
var _make_visualize_embeddable_factory = require("./embeddable/make_visualize_embeddable_factory");
var _saved_objects = require("./saved_objects");
var _content_management2 = require("../common/content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class VisualizationsPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    this.logger.debug('visualizations: Setup');
    const getSearchSourceMigrations = plugins.data.search.searchSource.getAllMigrations.bind(plugins.data.search.searchSource);
    core.savedObjects.registerType((0, _saved_objects.getVisualizationSavedObjectType)(getSearchSourceMigrations));
    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    plugins.embeddable.registerEmbeddableFactory((0, _make_visualize_embeddable_factory.makeVisualizeEmbeddableFactory)(getSearchSourceMigrations)());
    plugins.contentManagement.register({
      id: _content_management2.CONTENT_ID,
      storage: new _content_management.VisualizationsStorage(),
      version: {
        latest: _content_management2.LATEST_VERSION
      }
    });
    return {
      registerReadOnlyVisType: _saved_objects.registerReadOnlyVisType
    };
  }
  start(core) {
    this.logger.debug('visualizations: Started');
    return {};
  }
  stop() {}
}
exports.VisualizationsPlugin = VisualizationsPlugin;