"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useVisByValue = void 0;
var _react = require("react");
var _get_visualization_instance = require("../get_visualization_instance");
var _breadcrumbs = require("../breadcrumbs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useVisByValue = (services, eventEmitter, isChromeVisible, valueInput, originatingApp, originatingPath) => {
  const [state, setState] = (0, _react.useState)({});
  const visEditorRef = (0, _react.useRef)(null);
  const loaded = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    const {
      chrome,
      application: {
        navigateToApp
      },
      stateTransferService,
      visEditorsRegistry
    } = services;
    const getVisInstance = async () => {
      var _vis$type$editorConfi;
      if (!valueInput || loaded.current || !visEditorRef.current) {
        return;
      }
      const byValueVisInstance = await (0, _get_visualization_instance.getVisualizationInstanceFromInput)(services, valueInput);
      const {
        embeddableHandler,
        vis
      } = byValueVisInstance;
      let visEditorController;
      const Editor = visEditorsRegistry.get((_vis$type$editorConfi = vis.type.editorConfig) === null || _vis$type$editorConfi === void 0 ? void 0 : _vis$type$editorConfi.editor);
      if (Editor) {
        visEditorController = new Editor(visEditorRef.current, vis, eventEmitter, embeddableHandler);
      }
      const originatingAppName = originatingApp ? stateTransferService.getAppNameFromId(originatingApp) : undefined;
      const redirectToOrigin = originatingApp ? () => navigateToApp(originatingApp, {
        path: originatingPath
      }) : undefined;
      chrome === null || chrome === void 0 ? void 0 : chrome.setBreadcrumbs((0, _breadcrumbs.getEditBreadcrumbs)({
        byValue: true,
        originatingAppName,
        redirectToOrigin
      }));
      loaded.current = true;
      setState({
        byValueVisInstance,
        visEditorController
      });
    };
    getVisInstance();
  }, [eventEmitter, isChromeVisible, services, state.byValueVisInstance, state.visEditorController, valueInput, originatingApp, originatingPath]);
  (0, _react.useEffect)(() => {
    return () => {
      var _state$byValueVisInst;
      if (state.visEditorController) {
        state.visEditorController.destroy();
      } else if ((_state$byValueVisInst = state.byValueVisInstance) !== null && _state$byValueVisInst !== void 0 && _state$byValueVisInst.embeddableHandler) {
        state.byValueVisInstance.embeddableHandler.destroy();
      }
    };
  }, [state]);
  return {
    ...state,
    visEditorRef
  };
};
exports.useVisByValue = useVisByValue;