"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TypesService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _vis_type_alias_registry = require("./vis_type_alias_registry");
var _base_vis_type = require("./base_vis_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Vis Types Service
 *
 * @internal
 */
class TypesService {
  constructor() {
    (0, _defineProperty2.default)(this, "types", {});
  }
  registerVisualization(visDefinition) {
    if (this.types[visDefinition.name]) {
      throw new Error('type already exists!');
    }
    this.types[visDefinition.name] = visDefinition;
  }
  setup() {
    return {
      /**
       * registers a visualization type
       * @param config - visualization type definition
       */
      createBaseVisualization: config => {
        const vis = new _base_vis_type.BaseVisType(config);
        this.registerVisualization(vis);
      },
      /**
       * registers a visualization alias
       * alias is a visualization type without implementation, it just redirects somewhere in kibana
       * @param {VisTypeAlias} config - visualization alias definition
       */
      registerAlias: _vis_type_alias_registry.visTypeAliasRegistry.add
    };
  }
  start() {
    return {
      /**
       * returns specific visualization or undefined if not found
       * @param {string} visualization - id of visualization to return
       */
      get: visualization => {
        return this.types[visualization];
      },
      /**
       * returns all registered visualization types
       */
      all: () => {
        return [...Object.values(this.types)];
      },
      /**
       * returns all registered aliases
       */
      getAliases: _vis_type_alias_registry.visTypeAliasRegistry.get,
      /**
       * unregisters a visualization alias by its name
       * alias is a visualization type without implementation, it just redirects somewhere in kibana
       * @param {string} visTypeAliasName - visualization alias name
       */
      unRegisterAlias: _vis_type_alias_registry.visTypeAliasRegistry.remove,
      /**
       * returns all visualizations of specific group
       * @param {VisGroups} group - group type (aggbased | other | tools)
       */
      getByGroup: group => {
        return Object.values(this.types).filter(type => {
          return type.group === group;
        });
      }
    };
  }
  stop() {
    // nothing to do here yet
  }
}

/** @internal */
exports.TypesService = TypesService;