"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditInLensAction = exports.ACTION_EDIT_IN_LENS = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _operators = require("rxjs/operators");
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _triggers = require("../triggers");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_EDIT_IN_LENS = 'ACTION_EDIT_IN_LENS';
exports.ACTION_EDIT_IN_LENS = ACTION_EDIT_IN_LENS;
const displayName = _i18n.i18n.translate('visualizations.actions.editInLens.displayName', {
  defaultMessage: 'Convert to Lens'
});
const MenuItem = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, displayName), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: 'accent'
  }, _i18n.i18n.translate('visualizations.tonNavMenu.tryItBadgeText', {
    defaultMessage: 'Try it'
  }))));
};
const isVisualizeEmbeddable = embeddable => {
  return 'getVis' in embeddable;
};
class EditInLensAction {
  constructor(timefilter) {
    (0, _defineProperty2.default)(this, "id", ACTION_EDIT_IN_LENS);
    (0, _defineProperty2.default)(this, "type", ACTION_EDIT_IN_LENS);
    (0, _defineProperty2.default)(this, "order", 49);
    (0, _defineProperty2.default)(this, "showNotification", true);
    (0, _defineProperty2.default)(this, "currentAppId", void 0);
    (0, _defineProperty2.default)(this, "MenuItem", MenuItem);
    this.timefilter = timefilter;
  }
  async execute(context) {
    const application = (0, _services.getApplication)();
    if (application !== null && application !== void 0 && application.currentAppId$) {
      application.currentAppId$.pipe((0, _operators.take)(1)).subscribe(appId => this.currentAppId = appId);
      application.currentAppId$.subscribe(() => {
        (0, _services.getEmbeddable)().getStateTransfer().isTransferInProgress = false;
      });
    }
    const {
      embeddable
    } = context;
    if (isVisualizeEmbeddable(embeddable)) {
      var _vis$type$navigateToL, _vis$type, _vis$data$searchSourc, _vis$data$searchSourc2, _vis$data$searchSourc3, _parentSearchSource$g, _parentSearchSource$g2, _embeddable$getInput;
      const vis = embeddable.getVis();
      const navigateToLensConfig = await ((_vis$type$navigateToL = (_vis$type = vis.type).navigateToLens) === null || _vis$type$navigateToL === void 0 ? void 0 : _vis$type$navigateToL.call(_vis$type, vis, this.timefilter));
      // Filters and query set on the visualization level
      const visFilters = (_vis$data$searchSourc = vis.data.searchSource) === null || _vis$data$searchSourc === void 0 ? void 0 : _vis$data$searchSourc.getField('filter');
      const visQuery = (_vis$data$searchSourc2 = vis.data.searchSource) === null || _vis$data$searchSourc2 === void 0 ? void 0 : _vis$data$searchSourc2.getField('query');
      const parentSearchSource = (_vis$data$searchSourc3 = vis.data.searchSource) === null || _vis$data$searchSourc3 === void 0 ? void 0 : _vis$data$searchSourc3.getParent();
      const searchFilters = (_parentSearchSource$g = parentSearchSource === null || parentSearchSource === void 0 ? void 0 : parentSearchSource.getField('filter')) !== null && _parentSearchSource$g !== void 0 ? _parentSearchSource$g : visFilters;
      const searchQuery = (_parentSearchSource$g2 = parentSearchSource === null || parentSearchSource === void 0 ? void 0 : parentSearchSource.getField('query')) !== null && _parentSearchSource$g2 !== void 0 ? _parentSearchSource$g2 : visQuery;
      const title = vis.title || embeddable.getOutput().title;
      const updatedWithMeta = {
        ...navigateToLensConfig,
        title,
        visTypeTitle: vis.type.title,
        embeddableId: embeddable.id,
        originatingApp: this.currentAppId,
        searchFilters,
        searchQuery,
        isEmbeddable: true,
        description: vis.description || embeddable.getOutput().description,
        panelTimeRange: (_embeddable$getInput = embeddable.getInput()) === null || _embeddable$getInput === void 0 ? void 0 : _embeddable$getInput.timeRange
      };
      if (navigateToLensConfig) {
        if (this.currentAppId) {
          (0, _services.getUsageCollection)().reportUiCounter(this.currentAppId, _analytics.METRIC_TYPE.CLICK, ACTION_EDIT_IN_LENS);
        }
        (0, _services.getEmbeddable)().getStateTransfer().isTransferInProgress = true;
        (0, _services.getUiActions)().getTrigger(_triggers.DASHBOARD_VISUALIZATION_PANEL_TRIGGER).exec(updatedWithMeta);
      }
    }
  }
  getDisplayName(context) {
    return displayName;
  }
  getIconType(context) {
    return 'merge';
  }
  async isCompatible(context) {
    var _embeddable$getExpres, _embeddable$getExpres2, _embeddable$getExpres3, _vis$type$navigateToL2, _vis$type2;
    const {
      embeddable
    } = context;
    const {
      visualize
    } = (0, _services.getCapabilities)();
    if (!isVisualizeEmbeddable(embeddable) || !visualize.show) {
      return false;
    }
    const vis = embeddable.getVis();
    if (!vis) {
      return false;
    }
    const canNavigateToLens = (_embeddable$getExpres = (_embeddable$getExpres2 = embeddable.getExpressionVariables) === null || _embeddable$getExpres2 === void 0 ? void 0 : (_embeddable$getExpres3 = _embeddable$getExpres2.call(embeddable)) === null || _embeddable$getExpres3 === void 0 ? void 0 : _embeddable$getExpres3.canNavigateToLens) !== null && _embeddable$getExpres !== void 0 ? _embeddable$getExpres : await ((_vis$type$navigateToL2 = (_vis$type2 = vis.type).navigateToLens) === null || _vis$type$navigateToL2 === void 0 ? void 0 : _vis$type$navigateToL2.call(_vis$type2, vis, this.timefilter));
    return Boolean(canNavigateToLens && embeddable.getInput().viewMode === _public.ViewMode.EDIT);
  }
}
exports.EditInLensAction = EditInLensAction;