"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextDecorationSetting = TextDecorationSetting;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getSelectedOption({
  textField,
  textVisibility
} = {}, isQueryBased) {
  if (!textVisibility) {
    return 'none';
  }
  if (isQueryBased && textField) {
    return 'field';
  }
  return 'name';
}
function TextDecorationSetting({
  idPrefix,
  currentConfig,
  setConfig,
  isQueryBased,
  children
}) {
  // To model the temporary state for label based on field when user didn't pick up the field yet,
  // use a local state
  const [selectedVisibleOption, setVisibleOption] = (0, _react.useState)(getSelectedOption(currentConfig, isQueryBased));
  const options = [{
    id: `${idPrefix}none`,
    label: _i18n.i18n.translate('visualizationUiComponents.xyChart.lineMarker.textVisibility.none', {
      defaultMessage: 'None'
    }),
    'data-test-subj': 'lnsXY_textVisibility_none'
  }, {
    id: `${idPrefix}name`,
    label: _i18n.i18n.translate('visualizationUiComponents.xyChart.lineMarker.textVisibility.name', {
      defaultMessage: 'Name'
    }),
    'data-test-subj': 'lnsXY_textVisibility_name'
  }];
  if (isQueryBased) {
    options.push({
      id: `${idPrefix}field`,
      label: _i18n.i18n.translate('visualizationUiComponents.xyChart.lineMarker.textVisibility.field', {
        defaultMessage: 'Field'
      }),
      'data-test-subj': 'lnsXY_textVisibility_field'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visualizationUiComponents.lineMarker.textVisibility', {
      defaultMessage: 'Text decoration'
    }),
    display: "columnCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('visualizationUiComponents.lineMarker.textVisibility', {
      defaultMessage: 'Text decoration'
    }),
    "data-test-subj": "lns-lineMarker-text-visibility",
    name: "textVisibilityStyle",
    buttonSize: "compressed",
    options: options,
    idSelected: selectedVisibleOption ? `${idPrefix}${selectedVisibleOption}` : `${idPrefix}none`,
    onChange: id => {
      const chosenOption = id.replace(idPrefix, '');
      if (chosenOption === 'none') {
        setConfig({
          textVisibility: false,
          textField: undefined
        });
      } else if (chosenOption === 'name') {
        setConfig({
          textVisibility: true,
          textField: undefined
        });
      } else if (chosenOption === 'field') {
        setConfig({
          textVisibility: Boolean(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.textField)
        });
      }
      setVisibleOption(chosenOption);
    },
    isFullWidth: true
  }), children === null || children === void 0 ? void 0 : children(selectedVisibleOption)));
}