"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterQueryInput = FilterQueryInput;
exports.defaultFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _debounced_value = require("../debounced_value");
var _ = require(".");
require("./filter_query_input.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const filterByLabel = _i18n.i18n.translate('visualizationUiComponents.filterQueryInput.label', {
  defaultMessage: 'Filter by'
});

// to do: get the language from uiSettings
const defaultFilter = {
  query: '',
  language: 'kuery'
};
exports.defaultFilter = defaultFilter;
function FilterQueryInput({
  inputFilter,
  onChange,
  dataView,
  helpMessage,
  label = filterByLabel,
  initiallyOpen,
  ['data-test-subj']: dataTestSubj,
  queryInputServices,
  appName
}) {
  const [filterPopoverOpen, setFilterPopoverOpen] = (0, _react.useState)(Boolean(initiallyOpen));
  const {
    inputValue: queryInput,
    handleInputChange: setQueryInput
  } = (0, _debounced_value.useDebouncedValue)({
    value: inputFilter !== null && inputFilter !== void 0 ? inputFilter : defaultFilter,
    onChange
  });
  const onClosePopup = (0, _react.useCallback)(() => {
    setFilterPopoverOpen(false);
  }, []);
  const {
    isValid: isInputFilterValid
  } = (0, _.validateQuery)(inputFilter, dataView);
  const {
    isValid: isQueryInputValid,
    error: queryInputError
  } = (0, _.validateQuery)(queryInput, dataView);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: helpMessage ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      color: "subdued",
      content: helpMessage,
      iconProps: {
        className: 'eui-alignTop'
      },
      position: "top",
      size: "s",
      type: "questionInCircle"
    })) : label,
    fullWidth: true,
    isInvalid: !isInputFilterValid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: filterPopoverOpen,
    closePopover: onClosePopup,
    anchorClassName: "eui-fullWidth",
    panelClassName: "filterQueryInput__popover",
    initialFocus: dataTestSubj ? `textarea[data-test-subj='${dataTestSubj}']` : undefined,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "none",
      hasShadow: false,
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      className: "filterQueryInput__popoverButton",
      "data-test-subj": "indexPattern-filters-existingFilterTrigger",
      onClick: () => {
        setFilterPopoverOpen(!filterPopoverOpen);
      },
      color: isInputFilterValid ? 'text' : 'danger',
      title: _i18n.i18n.translate('visualizationUiComponents.filterQueryInput.clickToEdit', {
        defaultMessage: 'Click to edit'
      })
    }, (inputFilter === null || inputFilter === void 0 ? void 0 : inputFilter.query) || _i18n.i18n.translate('visualizationUiComponents.filterQueryInput.emptyFilterQuery', {
      defaultMessage: '(empty)'
    })))))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    isInvalid: !isQueryInputValid,
    error: queryInputError,
    fullWidth: true,
    "data-test-subj": "indexPattern-filter-by-input"
  }, /*#__PURE__*/_react.default.createElement(_.QueryInput, {
    dataView: dataView.id ? {
      type: 'id',
      value: dataView.id
    } : {
      type: 'title',
      value: dataView.title
    },
    disableAutoFocus: true,
    value: queryInput,
    onChange: setQueryInput,
    isInvalid: !isQueryInputValid,
    onSubmit: () => {},
    "data-test-subj": dataTestSubj,
    appName: appName,
    services: queryInputServices
  }))))));
}