"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LineStyleSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LineStyleSettings = ({
  currentConfig,
  setConfig,
  idPrefix
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('visualizationUiComponents.xyChart.lineStyle.label', {
      defaultMessage: 'Line'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(LineThicknessSlider, {
    value: (currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.lineWidth) || 1,
    onChange: value => {
      setConfig({
        lineWidth: value
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('visualizationUiComponents.xyChart.lineStyle.label', {
      defaultMessage: 'Line'
    }),
    "data-test-subj": "lnsXY_line_style",
    name: "lineStyle",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}solid`,
      label: _i18n.i18n.translate('visualizationUiComponents.xyChart.lineStyle.solid', {
        defaultMessage: 'Solid'
      }),
      'data-test-subj': 'lnsXY_line_style_solid',
      iconType: 'lineSolid'
    }, {
      id: `${idPrefix}dashed`,
      label: _i18n.i18n.translate('visualizationUiComponents.xyChart.lineStyle.dashed', {
        defaultMessage: 'Dashed'
      }),
      'data-test-subj': 'lnsXY_line_style_dashed',
      iconType: 'lineDashed'
    }, {
      id: `${idPrefix}dotted`,
      label: _i18n.i18n.translate('visualizationUiComponents.xyChart.lineStyle.dotted', {
        defaultMessage: 'Dotted'
      }),
      'data-test-subj': 'lnsXY_line_style_dotted',
      iconType: 'lineDotted'
    }],
    idSelected: `${idPrefix}${(currentConfig === null || currentConfig === void 0 ? void 0 : currentConfig.lineStyle) || 'solid'}`,
    onChange: id => {
      const newMode = id.replace(idPrefix, '');
      setConfig({
        lineStyle: newMode
      });
    },
    isIconOnly: true
  })))));
};
exports.LineStyleSettings = LineStyleSettings;
const minRange = 1;
const maxRange = 10;
function getSafeValue(value, prevValue, min, max) {
  if (value === '') {
    return prevValue;
  }
  return Math.max(minRange, Math.min(value, maxRange));
}
const LineThicknessSlider = ({
  value,
  onChange
}) => {
  const [unsafeValue, setUnsafeValue] = (0, _react.useState)(String(value));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "lnsXYThickness",
    value: unsafeValue,
    fullWidth: true,
    min: minRange,
    max: maxRange,
    step: 1,
    append: "px",
    compressed: true,
    onChange: ({
      currentTarget: {
        value: newValue
      }
    }) => {
      setUnsafeValue(newValue);
      const convertedValue = newValue === '' ? '' : Number(newValue);
      const safeValue = getSafeValue(Number(newValue), Number(newValue), minRange, maxRange);
      // only update onChange is the value is valid and in range
      if (convertedValue === safeValue) {
        onChange(safeValue);
      }
    },
    onBlur: () => {
      if (unsafeValue !== String(value)) {
        const safeValue = getSafeValue(unsafeValue === '' ? unsafeValue : Number(unsafeValue), value, minRange, maxRange);
        onChange(safeValue);
        setUnsafeValue(String(safeValue));
      }
    }
  });
};