"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconSelect = IconSelect;
exports.IconSelectSetting = IconSelectSetting;
exports.hasIcon = hasIcon;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function hasIcon(icon) {
  return icon != null && icon !== 'empty';
}
const IconView = props => {
  var _props$icon;
  if (!props.value) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: (_props$icon = props.icon) !== null && _props$icon !== void 0 ? _props$icon : props.value
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, props.label));
};
function IconSelect({
  value,
  onChange,
  customIconSet,
  defaultIcon = 'empty'
}) {
  var _selectedIcon$icon;
  const selectedIcon = customIconSet.find(option => value === option.value) || customIconSet.find(option => option.value === defaultIcon);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    "data-test-subj": "lns-icon-select",
    isClearable: false,
    options: customIconSet,
    selectedOptions: [{
      label: selectedIcon.label,
      value: selectedIcon.value
    }],
    onChange: selection => {
      onChange(selection[0].value);
    },
    singleSelection: {
      asPlainText: true
    },
    renderOption: IconView,
    compressed: true,
    prepend: hasIcon(selectedIcon.value) ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: (_selectedIcon$icon = selectedIcon.icon) !== null && _selectedIcon$icon !== void 0 ? _selectedIcon$icon : selectedIcon.value
    }) : undefined
  });
}
function IconSelectSetting({
  currentIcon,
  setIcon,
  customIconSet,
  defaultIcon = 'empty'
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: _i18n.i18n.translate('visualizationUiComponents.iconSelect.label', {
      defaultMessage: 'Icon decoration'
    })
  }, /*#__PURE__*/_react.default.createElement(IconSelect, {
    defaultIcon: defaultIcon,
    customIconSet: customIconSet,
    value: currentIcon,
    onChange: setIcon
  }));
}