"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultDimensionTriggerTooltip = exports.DimensionTrigger = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultDimensionTriggerTooltip = /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('visualizationUiComponents.configure.invalidConfigTooltip', {
  defaultMessage: 'Invalid configuration.'
}), /*#__PURE__*/_react.default.createElement("br", null), _i18n.i18n.translate('visualizationUiComponents.configure.invalidConfigTooltipClick', {
  defaultMessage: 'Click for more details.'
}));
exports.defaultDimensionTriggerTooltip = defaultDimensionTriggerTooltip;
const DimensionTrigger = ({
  id,
  label,
  color,
  dataTestSubj
}) => {
  let safeLabel = label;
  if (typeof label === 'string') {
    safeLabel = (label === null || label === void 0 ? void 0 : label.trim().length) > 0 ? label : _constants.emptyTitleText;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    id: id,
    color: color,
    css: (0, _react2.css)`
        width: 100%;
        padding: ${_uiTheme.euiThemeVars.euiSizeXS} ${_uiTheme.euiThemeVars.euiSizeS};
        word-break: break-word;
        font-weight: ${_uiTheme.euiThemeVars.euiFontWeightRegular};
      `,
    "data-test-subj": dataTestSubj || 'lns-dimensionTrigger'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("span", {
    className: "dimensionTrigger__textLabel",
    css: (0, _react2.css)`
              transition: background-color ${_uiTheme.euiThemeVars.euiAnimSpeedFast} ease-in-out;

              &:hover {
                text-decoration: underline;
              }
            `
  }, safeLabel))));
};
exports.DimensionTrigger = DimensionTrigger;