"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyDimensionButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _trigger = require("./trigger");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EmptyDimensionButton = ({
  label,
  ariaLabel,
  onClick,
  dataTestSubj,
  iconType,
  ...otherProps // from Drag&Drop integration
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, otherProps, {
    css: (0, _react2.css)`
        width: 100%;
        border-radius: ${_uiTheme.euiThemeVars.euiBorderRadius} !important;
        border: ${_uiTheme.euiThemeVars.euiBorderWidthThin} dashed ${_uiTheme.euiThemeVars.euiBorderColor} !important;
      `,
    color: "text" // as far as I can tell all this currently adds is the correct active background color
    ,
    size: "s",
    iconType: iconType !== null && iconType !== void 0 ? iconType : 'plus',
    contentProps: {
      css: (0, _react2.css)`
          justify-content: flex-start;
          padding: 0 !important;
          color: ${_uiTheme.euiThemeVars.euiTextSubduedColor};

          .euiButtonEmpty__text {
            margin-left: 0;
          }

          .euiIcon {
            margin-left: ${_uiTheme.euiThemeVars.euiSizeS};
          }
        `
    },
    "aria-label": ariaLabel,
    "data-test-subj": dataTestSubj,
    onClick: () => {
      onClick();
    }
  }), /*#__PURE__*/_react.default.createElement(_trigger.DimensionTrigger, {
    label: label,
    dataTestSubj: "emptyDimensionTrigger"
  }));
};
exports.EmptyDimensionButton = EmptyDimensionButton;