"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DimensionButton = DimensionButton;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _dimension_button_icon = require("./dimension_button_icon");
var _palette_indicator = require("./palette_indicator");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const triggerLinkA11yText = label => _i18n.i18n.translate('visualizationUiComponents.dimensionButton.editConfig', {
  defaultMessage: 'Edit {label} configuration',
  values: {
    label: label.trim().length ? label : _constants.emptyTitleText
  }
});
function DimensionButton({
  groupLabel,
  children,
  onClick,
  onRemoveClick,
  accessorConfig,
  label,
  message,
  ...otherProps // from Drag&Drop integration
}) {
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, otherProps, {
    css: (0, _react2.css)`
        ${(0, _eui.useEuiFontSize)('s')}
        border-radius: ${_uiTheme.euiThemeVars.euiBorderRadius};
        display: flex;
        align-items: center;
        overflow: hidden;
        min-height: ${_uiTheme.euiThemeVars.euiSizeXL};
        position: relative;

        &:hover,
        &:focus {
          .lnsLayerPanel__dimensionRemove {
            visibility: visible;
            opacity: 1;
            transition: opacity ${_uiTheme.euiThemeVars.euiAnimSpeedFast} ease-in-out;
          }
        }
      `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: message === null || message === void 0 ? void 0 : message.content,
    position: "left"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    className: "lnsLayerPanel__dimensionLink",
    css: (0, _react2.css)`
                width: 100%;
                &:hover {
                  text-decoration: none;
                }
              `,
    "data-test-subj": "lnsLayerPanel-dimensionLink",
    onClick: () => onClick(accessorConfig.columnId),
    "aria-label": triggerLinkA11yText(label),
    title: triggerLinkA11yText(label),
    color: (message === null || message === void 0 ? void 0 : message.severity) === 'error' ? 'danger' : (message === null || message === void 0 ? void 0 : message.severity) === 'warning' ? 'warning' : 'text'
  }, /*#__PURE__*/_react.default.createElement(_dimension_button_icon.DimensionButtonIcon, {
    severity: message === null || message === void 0 ? void 0 : message.severity,
    accessorConfig: accessorConfig
  }, children))))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "lnsLayerPanel__dimensionRemove",
    "data-test-subj": "indexPattern-dimension-remove",
    iconType: "trash",
    size: "xs",
    color: "danger",
    "aria-label": _i18n.i18n.translate('visualizationUiComponents.dimensionButton.removeColumnLabel', {
      defaultMessage: 'Remove configuration from "{groupLabel}"',
      values: {
        groupLabel
      }
    }),
    title: _i18n.i18n.translate('visualizationUiComponents.dimensionButton.removeColumnLabel', {
      defaultMessage: 'Remove configuration from "{groupLabel}"',
      values: {
        groupLabel
      }
    }),
    onClick: () => onRemoveClick(accessorConfig.columnId),
    css: (0, _react2.css)`
          margin-right: ${_uiTheme.euiThemeVars.euiSizeS};
          visibility: hidden;
          opacity: 0;
          color: ${_uiTheme.euiThemeVars.euiTextSubduedColor};

          &:hover {
            color: ${_uiTheme.euiThemeVars.euiColorDangerText};
          }
        `
  }), /*#__PURE__*/_react.default.createElement(_palette_indicator.PaletteIndicator, {
    accessorConfig: accessorConfig
  }));
}