"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisTypeXyPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _services = require("./services");
var _vis_types = require("./vis_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
class VisTypeXyPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "initializerContext", void 0);
    this.initializerContext = initializerContext;
  }
  setup(core, {
    visualizations,
    charts
  }) {
    (0, _services.setUISettings)(core.uiSettings);
    (0, _services.setPalettesService)(charts.palettes);
    const {
      readOnly
    } = this.initializerContext.config.get();
    _vis_types.visTypesDefinitions.forEach(visTypeDefinition => visualizations.createBaseVisualization({
      ...visTypeDefinition,
      disableCreate: Boolean(readOnly),
      disableEdit: Boolean(readOnly)
    }));
    return {};
  }
  start(core, {
    dataViews
  }) {
    (0, _services.setDataViewsStart)(dataViews);
    return {};
  }
}
exports.VisTypeXyPlugin = VisTypeXyPlugin;