"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPoint = getPoint;
var _services = require("../../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getPoint(table, x, series, row, rowIndex, y, z) {
  const xRow = x.accessor === -1 ? '_all' : row[x.accessor];
  const yRow = row[y.accessor];
  const zRow = z && row[z.accessor];
  const point = {
    x: xRow,
    y: yRow,
    z: zRow,
    extraMetrics: [],
    seriesRaw: series && {
      table,
      column: series[0].column,
      row: rowIndex,
      value: row[series[0].accessor]
    },
    xRaw: {
      table,
      column: x.column,
      row: rowIndex,
      value: xRow
    },
    yRaw: {
      table,
      column: y.column,
      row: rowIndex,
      value: yRow
    },
    zRaw: z && {
      table,
      column: z.column,
      row: rowIndex,
      value: zRow
    },
    tableRaw: table.$parent && {
      table: table.$parent.table,
      column: table.$parent.column,
      row: table.$parent.row,
      value: table.$parent.formattedKey,
      title: table.$parent.name
    },
    parent: series ? series[0] : null
  };
  if (point.y === 'NaN') {
    // filter out NaN from stats
    // from metrics that are not based at zero
    return;
  }
  if (series) {
    point.series = series.map(s => {
      const fieldFormatter = (0, _services.getFormatService)().deserialize(s.format);
      return fieldFormatter.convert(row[s.accessor]);
    }).join(' - ');
  } else if (y) {
    // If the data is not split up with a series aspect, then
    // each point's "series" becomes the y-agg that produced it
    point.series = y.title;
  }
  return point;
}