"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlParser = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _jquery = _interopRequireDefault(require("jquery"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This class processes all Vega spec customizations,
 * converting url object parameters into query results.
 */
class UrlParser {
  constructor(onWarning) {
    (0, _defineProperty2.default)(this, "_onWarning", void 0);
    this._onWarning = onWarning;
  }

  // noinspection JSMethodCanBeStatic
  /**
   * Update request object
   */
  parseUrl(obj, urlObj) {
    let url = urlObj.url;
    if (!url) {
      throw new Error(_i18n.i18n.translate('visTypeVega.urlParser.dataUrlRequiresUrlParameterInFormErrorMessage', {
        defaultMessage: '{dataUrlParam} requires a {urlParam} parameter in a form "{formLink}"',
        values: {
          dataUrlParam: '"data.url"',
          urlParam: '"url"',
          formLink: 'https://example.org/path/subpath'
        }
      }));
    }
    const query = urlObj.query;
    if (!query) {
      this._onWarning(_i18n.i18n.translate('visTypeVega.urlParser.urlShouldHaveQuerySubObjectWarningMessage', {
        defaultMessage: 'Using a {urlObject} should have a {subObjectName} sub-object',
        values: {
          urlObject: '"url": {"%type%": "url", "url": ...}',
          subObjectName: '"query"'
        }
      }));
    } else {
      url += (url.includes('?') ? '&' : '?') + _jquery.default.param(query);
    }
    obj.url = url;
  }

  /**
   * No-op - the url is already set during the parseUrl
   */
  populateData() {}
}
exports.UrlParser = UrlParser;