"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUniqueBuckets = exports.getMetricWithCollapseFn = exports.findMetricColumn = exports.excludeMetaFromLayers = void 0;
var _lodash = require("lodash");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _convert = require("./lib/convert");
var _series = require("./lib/series");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const excludeMetaFromLayers = layers => {
  const newLayers = {};
  Object.entries(layers).forEach(([layerId, layer]) => {
    const columns = layer.columns.map(_convert.excludeMetaFromColumn);
    newLayers[layerId] = {
      ...layer,
      columns
    };
  });
  return newLayers;
};
exports.excludeMetaFromLayers = excludeMetaFromLayers;
const excludeColumnIdsFromBucket = bucket => {
  const {
    columnId,
    ...restBucket
  } = bucket;
  if (bucket.operationType === _convert_to_lens.Operations.TERMS) {
    const {
      orderBy,
      orderAgg,
      ...restParams
    } = bucket.params;
    let orderByWithoutColumn = orderBy;
    if ('columnId' in orderBy) {
      const {
        columnId: orderByColumnId,
        ...restOrderBy
      } = orderBy;
      orderByWithoutColumn = restOrderBy;
    }
    let orderAggWithoutColumn = orderAgg;
    if (orderAgg) {
      const {
        columnId: cId,
        ...restOrderAgg
      } = orderAgg;
      orderAggWithoutColumn = restOrderAgg;
    }
    return {
      ...restBucket,
      params: {
        ...restParams,
        orderBy: orderByWithoutColumn,
        orderAgg: orderAggWithoutColumn
      }
    };
  }
  return restBucket;
};
const getUniqueBuckets = buckets => (0, _lodash.uniqWith)(buckets, (bucket1, bucket2) => {
  if (bucket1.operationType !== bucket2.operationType) {
    return false;
  }
  const bucketWithoutColumnIds1 = excludeColumnIdsFromBucket(bucket1);
  const bucketWithoutColumnIds2 = excludeColumnIdsFromBucket(bucket2);
  return (0, _reactFastCompare.default)(bucketWithoutColumnIds1, bucketWithoutColumnIds2);
});
exports.getUniqueBuckets = getUniqueBuckets;
const getMetricWithCollapseFn = series => {
  if (!series) {
    return;
  }
  const {
    metrics,
    seriesAgg
  } = (0, _series.getSeriesAgg)(series.metrics);
  const visibleMetric = metrics[metrics.length - 1];
  return {
    metric: visibleMetric,
    collapseFn: seriesAgg
  };
};
exports.getMetricWithCollapseFn = getMetricWithCollapseFn;
const findMetricColumn = (metric, columns) => {
  if (!metric) {
    return;
  }
  return columns.find(column => 'meta' in column && column.meta.metricId === metric.id);
};
exports.findMetricColumn = findMetricColumn;