"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTimeScaleValue = exports.getTimeScale = exports.getReducedTimeRange = exports.getFormulaEquivalent = exports.addAdditionalArgs = void 0;
var _moment = require("moment");
var _public = require("@kbn/data-plugin/public");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _common = require("@kbn/data-plugin/common");
var _services = require("../../../services");
var _enums = require("../../../../common/enums");
var _filter_ratio_formula = require("./filter_ratio_formula");
var _supported_metrics = require("./supported_metrics");
var _counter_rate_formula = require("./counter_rate_formula");
var _pipeline_formula = require("./pipeline_formula");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const shouldCalculateReducedTimeRange = timeRangeMode => {
  return timeRangeMode === _enums.TIME_RANGE_DATA_MODES.LAST_VALUE;
};
const getReducedTimeRange = (model, series, timeRange) => {
  if (!shouldCalculateReducedTimeRange(series.override_index_pattern ? series.time_range_mode : model.time_range_mode)) {
    return undefined;
  }
  const interval = series.override_index_pattern ? series.series_interval : model.interval;
  let reducedTimeRange = interval || '1h';
  if (timeRange && !interval) {
    const {
      from,
      to
    } = timeRange;
    const timerange = (0, _moment.utc)(to).valueOf() - (0, _moment.utc)(from).valueOf();
    const maxBars = (0, _services.getUISettings)().get(_common.UI_SETTINGS.HISTOGRAM_BAR_TARGET);
    const duration = _public.search.aggs.calcAutoIntervalLessThan(maxBars, timerange);
    const unit = _datemath.default.units.find(u => {
      const value = duration.as(u);
      return Number.isInteger(value);
    }) || 'ms';
    reducedTimeRange = `${duration.as(unit)}${unit}`;
  }
  return reducedTimeRange;
};
exports.getReducedTimeRange = getReducedTimeRange;
const isTimeScaleValue = unit => {
  const supportedTimeScales = ['1s', '1m', '1h', '1d'];
  return supportedTimeScales.includes(unit);
};
exports.isTimeScaleValue = isTimeScaleValue;
const getTimeScale = metric => {
  let timeScale;
  if (metric.unit && isTimeScaleValue(metric.unit)) {
    timeScale = metric.unit.replace('1', '');
  }
  return timeScale;
};
exports.getTimeScale = getTimeScale;
const addTimeRangeToFormula = reducedTimeRange => {
  return reducedTimeRange ? `, reducedTimeRange='${reducedTimeRange}'` : '';
};
const addTimeShiftToFormula = timeShift => {
  return timeShift ? `, shift='${timeShift}'` : '';
};
const addAdditionalArgs = ({
  reducedTimeRange,
  timeShift
}) => {
  return `${addTimeShiftToFormula(timeShift)}${addTimeRangeToFormula(reducedTimeRange)}`;
};
exports.addAdditionalArgs = addAdditionalArgs;
const getFormulaEquivalent = (currentMetric, metrics, {
  metaValue,
  reducedTimeRange,
  timeShift
} = {}) => {
  const aggregation = _supported_metrics.SUPPORTED_METRICS[currentMetric.type];
  if (!aggregation) {
    return null;
  }
  const aggFormula = (0, _supported_metrics.getFormulaFromMetric)(aggregation);
  switch (currentMetric.type) {
    case 'cumulative_sum':
    case 'derivative':
    case 'moving_average':
    case 'avg_bucket':
    case 'max_bucket':
    case 'min_bucket':
    case 'sum_bucket':
    case 'positive_only':
      {
        var _currentMetric$field$, _currentMetric$field;
        const [subMetricId, nestedMetaValue] = (_currentMetric$field$ = currentMetric === null || currentMetric === void 0 ? void 0 : (_currentMetric$field = currentMetric.field) === null || _currentMetric$field === void 0 ? void 0 : _currentMetric$field.split('[')) !== null && _currentMetric$field$ !== void 0 ? _currentMetric$field$ : [];
        const subFunctionMetric = metrics.find(metric => metric.id === subMetricId);
        if (!subFunctionMetric || !_supported_metrics.SUPPORTED_METRICS[subFunctionMetric.type]) {
          return null;
        }
        return (0, _pipeline_formula.getPipelineSeriesFormula)(currentMetric, metrics, subFunctionMetric, {
          metaValue: nestedMetaValue ? Number(nestedMetaValue === null || nestedMetaValue === void 0 ? void 0 : nestedMetaValue.replace(']', '')) : undefined,
          reducedTimeRange,
          timeShift
        });
      }
    case 'count':
      {
        return `${aggFormula}(${timeShift ? `shift='${timeShift}'` : ''}${timeShift && reducedTimeRange ? ', ' : ''}${reducedTimeRange ? `reducedTimeRange='${reducedTimeRange}'` : ''})`;
      }
    case 'percentile':
      {
        return `${aggFormula}(${currentMetric.field}${metaValue ? `, percentile=${metaValue}` : ''}${addAdditionalArgs({
          reducedTimeRange,
          timeShift
        })})`;
      }
    case 'percentile_rank':
      {
        return `${aggFormula}(${currentMetric.field}${metaValue ? `, value=${metaValue}` : ''}${addAdditionalArgs({
          reducedTimeRange,
          timeShift
        })})`;
      }
    case 'positive_rate':
      {
        const counterRateFormula = (0, _counter_rate_formula.buildCounterRateFormula)(aggFormula, currentMetric.field, {
          reducedTimeRange,
          timeShift
        });
        return currentMetric.unit ? `normalize_by_unit(${counterRateFormula}, unit='${getTimeScale(currentMetric)}')` : counterRateFormula;
      }
    case 'filter_ratio':
      {
        return (0, _filter_ratio_formula.getFilterRatioFormula)(currentMetric, {
          reducedTimeRange,
          timeShift
        });
      }
    case 'static':
      {
        return `${currentMetric.value}`;
      }
    case 'variance':
      {
        return `${aggFormula}(standard_deviation(${currentMetric.field}${addAdditionalArgs({
          reducedTimeRange,
          timeShift
        })}), 2)`;
      }
    case 'std_deviation':
      {
        if (currentMetric.mode === 'lower') {
          return `average(${currentMetric.field}${addAdditionalArgs({
            reducedTimeRange,
            timeShift
          })}) - ${currentMetric.sigma || 1.5} * ${aggFormula}(${currentMetric.field}${addAdditionalArgs({
            reducedTimeRange,
            timeShift
          })})`;
        }
        if (currentMetric.mode === 'upper') {
          return `average(${currentMetric.field}${addAdditionalArgs({
            reducedTimeRange,
            timeShift
          })}) + ${currentMetric.sigma || 1.5} * ${aggFormula}(${currentMetric.field}${addAdditionalArgs({
            reducedTimeRange,
            timeShift
          })})`;
        }
        return `${aggFormula}(${currentMetric.field})`;
      }
    default:
      {
        var _currentMetric$field2;
        return `${aggFormula}(${(_currentMetric$field2 = currentMetric.field) !== null && _currentMetric$field2 !== void 0 ? _currentMetric$field2 : ''}${addAdditionalArgs({
          reducedTimeRange,
          timeShift
        })})`;
      }
  }
};
exports.getFormulaEquivalent = getFormulaEquivalent;