"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToDateHistogramParams = exports.convertToDateHistogramColumn = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getInterval = interval => {
  return interval && !(interval !== null && interval !== void 0 && interval.includes('=')) ? interval : 'auto';
};
const convertToDateHistogramParams = (model, series, includeEmptyRows = true) => {
  var _model$drop_last_buck;
  return {
    interval: getInterval(series.override_index_pattern ? series.series_interval : model === null || model === void 0 ? void 0 : model.interval),
    dropPartials: series.override_index_pattern ? series.series_drop_last_bucket > 0 : ((_model$drop_last_buck = model === null || model === void 0 ? void 0 : model.drop_last_bucket) !== null && _model$drop_last_buck !== void 0 ? _model$drop_last_buck : 0) > 0,
    includeEmptyRows
  };
};
exports.convertToDateHistogramParams = convertToDateHistogramParams;
const convertToDateHistogramColumn = (model, series, dataView, {
  fieldName,
  isSplit,
  includeEmptyRows = true
}) => {
  const dateField = dataView.getFieldByName(fieldName);
  if (!dateField) {
    return null;
  }
  const params = convertToDateHistogramParams(model, series, includeEmptyRows);
  return {
    columnId: (0, _uuid.v4)(),
    operationType: 'date_histogram',
    dataType: dateField.type,
    isBucketed: true,
    isSplit,
    sourceField: dateField.name,
    params
  };
};
exports.convertToDateHistogramColumn = convertToDateHistogramColumn;