"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isColumnWithMeta = exports.getFormat = exports.excludeMetaFromColumn = exports.createColumn = void 0;
var _uuid = require("uuid");
var _enums = require("../../../../common/enums");
var _metrics = require("../metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isSupportedFormat = format => ['bytes', 'number', 'percent'].includes(format);
const getFormat = series => {
  let suffix;
  if (!series.formatter || series.formatter === 'default') {
    return {};
  }
  if (series.value_template) {
    suffix = series.value_template.split('}}')[1];
  }

  // not supported formatters should be converted to number
  if (!isSupportedFormat(series.formatter)) {
    return {
      format: {
        id: _enums.DATA_FORMATTERS.NUMBER,
        ...(suffix && {
          params: {
            suffix,
            decimals: 2
          }
        })
      }
    };
  }
  return {
    format: {
      id: series.formatter,
      ...(suffix && {
        params: {
          suffix,
          decimals: 2
        }
      })
    }
  };
};
exports.getFormat = getFormat;
const createColumn = (series, metric, field, {
  isBucketed = false,
  isSplit = false,
  reducedTimeRange,
  timeShift,
  isAssignTimeScale = true
} = {}) => {
  var _ref;
  return {
    columnId: (0, _uuid.v4)(),
    dataType: (_ref = field === null || field === void 0 ? void 0 : field.type) !== null && _ref !== void 0 ? _ref : undefined,
    label: series.label,
    isBucketed,
    isSplit,
    reducedTimeRange,
    filter: series.filter,
    timeShift,
    timeScale: isAssignTimeScale ? (0, _metrics.getTimeScale)(metric) : undefined,
    meta: {
      metricId: metric.id
    }
  };
};
exports.createColumn = createColumn;
const isColumnWithMeta = column => {
  if (column.meta) {
    return true;
  }
  return false;
};
exports.isColumnWithMeta = isColumnWithMeta;
const excludeMetaFromColumn = column => {
  if (isColumnWithMeta(column)) {
    const {
      meta,
      ...rest
    } = column;
    return rest;
  }
  return column;
};
exports.excludeMetaFromColumn = excludeMetaFromColumn;