"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isColumnWithReference = exports.getLayers = void 0;
var _convert_to_lens = require("@kbn/visualizations-plugin/common/convert_to_lens");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _color = _interopRequireDefault(require("color"));
var _uiTheme = require("@kbn/ui-theme");
var _lodash = require("lodash");
var _get_default_query_language = require("../../../../application/components/lib/get_default_query_language");
var _constants = require("../../../../application/visualizations/constants");
var _metrics = require("../../metrics");
var _series = require("../../series");
var _convert = require("../../convert");
var _chart_type = require("./chart_type");
var _datasource = require("../../datasource");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isColumnWithReference = column => Boolean(column.references);
exports.isColumnWithReference = isColumnWithReference;
function getPalette(palette) {
  return !palette || palette.name === 'gradient' || palette.name === 'rainbow' ? {
    name: 'default',
    type: 'palette'
  } : palette;
}
function getAxisMode(series, model) {
  return series.separate_axis ? series.axis_position : model.axis_position;
}
function getColor(metricColumn, metric, seriesColor, splitAccessor) {
  if ((0, _convert.isPercentileColumnWithMeta)(metricColumn) && !splitAccessor) {
    var _metric$percentiles, _metric$percentiles$p;
    const [_, percentileIndex] = metricColumn.meta.reference.split('.');
    return (_metric$percentiles = metric.percentiles) === null || _metric$percentiles === void 0 ? void 0 : (_metric$percentiles$p = _metric$percentiles[parseInt(percentileIndex, 10)]) === null || _metric$percentiles$p === void 0 ? void 0 : _metric$percentiles$p.color;
  }
  if ((0, _convert.isPercentileRanksColumnWithMeta)(metricColumn) && !splitAccessor) {
    var _metric$colors;
    const [_, percentileRankIndex] = metricColumn.meta.reference.split('.');
    return (_metric$colors = metric.colors) === null || _metric$colors === void 0 ? void 0 : _metric$colors[parseInt(percentileRankIndex, 10)];
  }
  return seriesColor;
}
function nonNullable(value) {
  return value != null;
}
const getLayers = async (dataSourceLayers, model, dataViews, isSingleAxis = false) => {
  const nonAnnotationsLayers = Object.keys(dataSourceLayers).map(key => {
    var _dataSourceLayer$colu;
    const series = model.series[parseInt(key, 10)];
    const {
      metrics,
      seriesAgg
    } = (0, _series.getSeriesAgg)(series.metrics);
    const dataSourceLayer = dataSourceLayers[parseInt(key, 10)];
    const referenceColumn = dataSourceLayer.columns.find(column => isColumnWithReference(column));
    // as pipiline aggregation has only one reference id
    const referenceColumnId = referenceColumn === null || referenceColumn === void 0 ? void 0 : referenceColumn.references[0];
    // we should not include columns which using as reference for pipeline aggs
    const metricColumns = dataSourceLayer.columns.filter(l => !l.isBucketed && l.columnId !== referenceColumnId);
    const isReferenceLine = metricColumns.length === 1 && metricColumns[0].operationType === 'static_value';
    const splitAccessor = (_dataSourceLayer$colu = dataSourceLayer.columns.find(column => column.isBucketed && column.isSplit)) === null || _dataSourceLayer$colu === void 0 ? void 0 : _dataSourceLayer$colu.columnId;
    const chartType = (0, _chart_type.getChartType)(series, model.type);
    const commonProps = {
      layerId: dataSourceLayer.layerId,
      accessors: metricColumns.map(metricColumn => {
        return metricColumn.columnId;
      }),
      yConfig: metricColumns.map(metricColumn => {
        const metric = metrics.find(m => {
          var _SUPPORTED_METRICS$m$;
          return ((_SUPPORTED_METRICS$m$ = _metrics.SUPPORTED_METRICS[m.type]) === null || _SUPPORTED_METRICS$m$ === void 0 ? void 0 : _SUPPORTED_METRICS$m$.name) === metricColumn.operationType;
        });
        return {
          forAccessor: metricColumn.columnId,
          color: getColor(metricColumn, metric, series.color, splitAccessor),
          axisMode: isReferenceLine // reference line should be assigned to axis with real data
          ? model.series.some(s => s.id !== series.id && getAxisMode(s, model) === 'right') ? 'right' : 'left' : isSingleAxis ? 'left' : getAxisMode(series, model),
          ...(isReferenceLine && {
            fill: chartType.includes('area') ? _convert_to_lens.FillTypes.BELOW : _convert_to_lens.FillTypes.NONE,
            lineWidth: series.line_width
          })
        };
      })
    };
    if (isReferenceLine) {
      return {
        layerType: 'referenceLine',
        ...commonProps
      };
    } else {
      var _dataSourceLayer$colu2;
      return {
        seriesType: chartType,
        layerType: 'data',
        ...commonProps,
        xAccessor: (_dataSourceLayer$colu2 = dataSourceLayer.columns.find(column => column.isBucketed && !column.isSplit)) === null || _dataSourceLayer$colu2 === void 0 ? void 0 : _dataSourceLayer$colu2.columnId,
        splitAccessor,
        collapseFn: seriesAgg,
        palette: getPalette(series.palette)
      };
    }
  });
  if (!model.annotations || !model.annotations.length) {
    return nonAnnotationsLayers;
  }
  const annotationsByIndexPatternAndIgnoreFlag = (0, _lodash.groupBy)(model.annotations, a => {
    var _a$time_field;
    const id = typeof a.index_pattern === 'object' && 'id' in a.index_pattern ? a.index_pattern.id : a.index_pattern;
    return `${id}-${(_a$time_field = a.time_field) !== null && _a$time_field !== void 0 ? _a$time_field : ''}-${Boolean(a.ignore_global_filters)}`;
  });
  try {
    const annotationsLayers = await Promise.all(Object.values(annotationsByIndexPatternAndIgnoreFlag).map(async annotations => {
      const [firstAnnotation] = annotations;
      const convertedAnnotations = [];
      const result = await (0, _datasource.extractOrGenerateDatasourceInfo)(firstAnnotation.index_pattern, firstAnnotation.time_field, false, undefined, undefined, dataViews);
      if (!result) {
        throw new Error('Invalid annotation datasource');
      }
      const {
        indexPattern
      } = result;
      if (indexPattern) {
        annotations.forEach(a => {
          const lensAnnotation = convertAnnotation(a, indexPattern);
          if (lensAnnotation) {
            convertedAnnotations.push(lensAnnotation);
          }
        });
        return {
          layerId: (0, _uuid.v4)(),
          layerType: 'annotations',
          ignoreGlobalFilters: Boolean(firstAnnotation.ignore_global_filters),
          annotations: convertedAnnotations,
          indexPatternId: indexPattern.id
        };
      }
    }));
    return nonAnnotationsLayers.concat(...annotationsLayers.filter(nonNullable));
  } catch (e) {
    return null;
  }
};
exports.getLayers = getLayers;
const convertAnnotation = (annotation, dataView) => {
  var _annotation$fields, _annotation$query_str, _annotation$query_str2;
  const extraFields = (_annotation$fields = annotation.fields) === null || _annotation$fields === void 0 ? void 0 : _annotation$fields.replace(/\s/g, '').split(',').map(field => {
    const dataViewField = dataView.getFieldByName(field);
    return dataViewField && dataViewField.aggregatable ? field : undefined;
  }).filter(nonNullable);
  return {
    type: 'query',
    id: annotation.id,
    label: 'Event',
    key: {
      type: 'point_in_time'
    },
    color: new _color.default((0, _eui.transparentize)(annotation.color || _uiTheme.euiLightVars.euiColorAccent, 1)).hex(),
    timeField: annotation.time_field || dataView.timeFieldName,
    icon: annotation.icon && _constants.ICON_TYPES_MAP[annotation.icon] && typeof _constants.ICON_TYPES_MAP[annotation.icon] === 'string' ? _constants.ICON_TYPES_MAP[annotation.icon] : 'triangle',
    filter: {
      type: 'kibana_query',
      query: ((_annotation$query_str = annotation.query_string) === null || _annotation$query_str === void 0 ? void 0 : _annotation$query_str.query) || '*',
      language: ((_annotation$query_str2 = annotation.query_string) === null || _annotation$query_str2 === void 0 ? void 0 : _annotation$query_str2.language) || (0, _get_default_query_language.getDefaultQueryLanguage)()
    },
    extraFields,
    isHidden: annotation.hidden
  };
};