"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SplitByEverything = void 0;
var _create_select_handler = require("../lib/create_select_handler");
var _group_by_select = require("./group_by_select");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const SplitByEverything = props => {
  const {
    onChange,
    model,
    uiRestrictions
  } = props;
  const htmlId = (0, _eui.htmlIdGenerator)();
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(onChange);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('group'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.splits.everything.groupByLabel",
      defaultMessage: "Group by"
    })
  }, /*#__PURE__*/_react.default.createElement(_group_by_select.GroupBySelect, {
    value: model.split_mode,
    onChange: handleSelectChange('split_mode'),
    uiRestrictions: uiRestrictions
  }))));
};
exports.SplitByEverything = SplitByEverything;
SplitByEverything.propTypes = {
  model: _propTypes.default.object,
  onChange: _propTypes.default.func,
  uiRestrictions: _propTypes.default.object
};