"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTickFormatter = void 0;
var _lodash = require("lodash");
var _handlebars = _interopRequireWildcard(require("@kbn/handlebars"));
var _last_value_utils = require("../../../../common/last_value_utils");
var _durations = require("./durations");
var _services = require("../../../services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createTickFormatter = (format = '0,0.[00]', template, getConfig = null) => {
  const fieldFormats = (0, _services.getFieldFormats)();
  if (!template) template = '{{value}}';
  const render = _handlebars.default[_handlebars.compileFnName](template, {
    noEscape: true,
    knownHelpersOnly: true
  });
  let formatter;
  if ((0, _durations.isDuration)(format)) {
    const [from, to, decimals] = format.split(',');
    const DurationFormat = fieldFormats.getType('duration');
    formatter = new DurationFormat({
      inputFormat: _durations.inputFormats[from],
      outputFormat: _durations.outputFormats[to],
      outputPrecision: decimals
    });
  } else {
    let FieldFormat = fieldFormats.getType(format);
    if (FieldFormat) {
      formatter = new FieldFormat(null, getConfig);
    } else {
      FieldFormat = fieldFormats.getType('number');
      formatter = new FieldFormat({
        pattern: format
      }, getConfig);
    }
  }
  return val => {
    if ((0, _last_value_utils.isEmptyValue)(val)) {
      return _last_value_utils.DISPLAY_EMPTY_VALUE;
    }
    let value;
    if (!(0, _lodash.isNumber)(val)) {
      value = val;
    } else {
      try {
        value = formatter.convert(val, 'text');
      } catch (e) {
        value = val;
      }
    }
    try {
      return render({
        value
      });
    } catch (e) {
      return String(value);
    }
  };
};
exports.createTickFormatter = createTickFormatter;