"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTextSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _switch_mode_popover = require("./switch_mode_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const updateIndexText = _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.updateIndex', {
  defaultMessage: 'Update visualization with entered data view'
});
const FieldTextSelect = ({
  fetchedIndex,
  onIndexChange,
  disabled,
  placeholder,
  onModeChange,
  allowSwitchMode,
  'data-test-subj': dataTestSubj
}) => {
  const [inputValue, setInputValue] = (0, _react.useState)();
  const {
    indexPatternString
  } = fetchedIndex;
  const onFieldTextChange = (0, _react.useCallback)(e => {
    setInputValue(e.target.value);
  }, []);
  (0, _react.useEffect)(() => {
    if (inputValue === undefined) {
      setInputValue(indexPatternString !== null && indexPatternString !== void 0 ? indexPatternString : '');
    }
  }, [indexPatternString, inputValue]);
  const updateIndex = (0, _react.useCallback)(() => {
    if ((inputValue !== null && inputValue !== void 0 ? inputValue : '') !== (indexPatternString !== null && indexPatternString !== void 0 ? indexPatternString : '')) {
      onIndexChange(inputValue);
    }
  }, [onIndexChange, inputValue, indexPatternString]);
  const appends = [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": updateIndexText,
    iconType: "play",
    onClick: updateIndex,
    disabled: inputValue === indexPatternString
  })];
  if (allowSwitchMode) {
    appends.push( /*#__PURE__*/_react.default.createElement(_switch_mode_popover.SwitchModePopover, {
      onModeChange: onModeChange,
      fetchedIndex: fetchedIndex,
      useKibanaIndices: false
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    onChange: onFieldTextChange,
    value: inputValue !== null && inputValue !== void 0 ? inputValue : '',
    placeholder: placeholder,
    "data-test-subj": dataTestSubj,
    append: appends
  });
};
exports.FieldTextSelect = FieldTextSelect;