"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Agg = Agg;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _agg_to_component = require("../lib/agg_to_component");
var _check_ui_restrictions = require("../../../../common/check_ui_restrictions");
var _invalid_agg = require("./invalid_agg");
var _series_change_handler = require("../lib/series_change_handler");
var _check_if_numeric_metric = require("../lib/check_if_numeric_metric");
var _get_formatter_type = require("../lib/get_formatter_type");
var _enums = require("../../../../common/enums");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-ignore

function Agg(props) {
  const {
    model,
    uiRestrictions,
    series,
    name,
    onModelChange,
    fields,
    siblings
  } = props;
  const type = model.type;
  let Component = _agg_to_component.aggToComponent[type];
  if (!Component) {
    Component = (0, _invalid_agg.getInvalidAggComponent)( /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.agg.aggIsNotSupportedDescription",
      defaultMessage: "The {modelType} aggregation is no longer supported.",
      values: {
        modelType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, props.model.type)
      }
    }));
  } else if (!(0, _check_ui_restrictions.isMetricEnabled)(model.type, uiRestrictions)) {
    Component = (0, _invalid_agg.getInvalidAggComponent)( /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.agg.aggIsUnsupportedForPanelConfigDescription",
      defaultMessage: "The {modelType} aggregation is not supported for existing panel configuration.",
      values: {
        modelType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, props.model.type)
      }
    }));
  }
  const style = {
    cursor: 'default',
    ...props.style
  };
  const indexPattern = props.series.override_index_pattern ? props.series.series_index_pattern : props.panel.index_pattern;
  const isKibanaIndexPattern = props.panel.use_kibana_indexes || indexPattern === '';
  const onAggChange = (0, _react.useMemo)(() => (0, _series_change_handler.seriesChangeHandler)({
    name,
    model: series,
    onChange: onModelChange
  }, siblings), [name, onModelChange, siblings, series]);
  (0, _react.useEffect)(() => {
    var _siblings;
    // formatter is based on the last agg, i.e. active or resulting one as pipeline
    if (((_siblings = siblings[siblings.length - 1]) === null || _siblings === void 0 ? void 0 : _siblings.id) === model.id) {
      const formatterType = (0, _get_formatter_type.getFormatterType)(series.formatter);
      const isNumericMetric = (0, _check_if_numeric_metric.checkIfNumericMetric)(model, fields, indexPattern);
      const isNumberFormatter = ![_enums.DATA_FORMATTERS.DEFAULT, _enums.DATA_FORMATTERS.CUSTOM].includes(formatterType);
      if (isNumberFormatter && !isNumericMetric) {
        onModelChange({
          formatter: _enums.DATA_FORMATTERS.DEFAULT
        });
      }
      // in case of string index pattern mode, change default formatter depending on metric type
      // "number" formatter for numeric metric and "" as custom formatter for any other type
      if (formatterType === _enums.DATA_FORMATTERS.DEFAULT && !isKibanaIndexPattern) {
        onModelChange({
          formatter: isNumericMetric ? _enums.DATA_FORMATTERS.NUMBER : ''
        });
      }
    }
  }, [indexPattern, model, onModelChange, fields, series.formatter, isKibanaIndexPattern, siblings]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: props.className,
    style: style
  }, /*#__PURE__*/_react.default.createElement(Component, {
    fields: props.fields,
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onChange: onAggChange,
    onDelete: props.onDelete,
    panel: props.panel,
    series: props.series,
    siblings: props.siblings,
    indexPattern: indexPattern,
    uiRestrictions: props.uiRestrictions,
    dragHandleProps: props.dragHandleProps
  }));
}