"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelionVisDefinition = getTimelionVisDefinition;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _constants = require("../common/constants");
var _to_ast = require("./to_ast");
var _plugin_services = require("./helpers/plugin_services");
var _parser_async = require("../common/parser_async");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const TimelionOptions = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./timelion_options'))));
function getTimelionVisDefinition(dependencies) {
  // return the visType object, which kibana will use to display and configure new
  // Vis object of this type.
  return {
    name: _constants.TIMELION_VIS_NAME,
    title: 'Timelion',
    icon: 'visTimelion',
    description: _i18n.i18n.translate('timelion.timelionDescription', {
      defaultMessage: 'Show time series data on a graph.'
    }),
    visConfig: {
      defaults: {
        expression: '.es(*)',
        interval: 'auto'
      }
    },
    editorConfig: {
      optionsTemplate: props => /*#__PURE__*/_react.default.createElement(TimelionOptions, (0, _extends2.default)({
        services: dependencies
      }, props)),
      defaultSize: _public.DefaultEditorSize.MEDIUM
    },
    toExpressionAst: _to_ast.toExpressionAst,
    inspectorAdapters: {},
    getSupportedTriggers: () => {
      return [_public2.VIS_EVENT_TO_TRIGGER.applyFilter];
    },
    getUsedIndexPattern: async params => {
      try {
        var _await$parseTimelionE, _await$parseTimelionE2;
        const args = (_await$parseTimelionE = (_await$parseTimelionE2 = await (0, _parser_async.parseTimelionExpressionAsync)(params.expression)) === null || _await$parseTimelionE2 === void 0 ? void 0 : _await$parseTimelionE2.args) !== null && _await$parseTimelionE !== void 0 ? _await$parseTimelionE : [];
        const indexArg = args.find(({
          type,
          name,
          function: fn
        }) => type === 'namedArg' && fn === 'es' && name === 'index');
        if (indexArg !== null && indexArg !== void 0 && indexArg.value.text) {
          return (0, _plugin_services.getIndexPatterns)().find(indexArg.value.text, 1);
        }
      } catch {
        // timelion expression is invalid
      }
      return [];
    },
    options: {
      showIndexSelection: false,
      showFilterBar: false,
      showQueryInput: false
    },
    requiresSearch: true
  };
}